/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.user.feign.service;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.user.api.appinstance.AppInstanceApi;
import com.cyberway.mp.user.api.appinstance.dto.AppFormPageResourceMenuDto;
import com.cyberway.mp.user.api.appinstance.dto.AppFormPageResourceMenuImportDto;
import com.cyberway.mp.user.api.appinstance.dto.AppInstanceBaseInfoQueryDto;
import com.cyberway.mp.user.api.appinstance.dto.AppInstanceCreateDto;
import com.cyberway.mp.user.api.appinstance.dto.AppInstanceCreateForTenantDto;
import com.cyberway.mp.user.api.appinstance.dto.AppInstanceInitDto;
import com.cyberway.mp.user.api.appinstance.dto.AppInstanceLowCodePageSyncDto;
import com.cyberway.mp.user.api.appinstance.dto.AppInstanceMenuInitDto;
import com.cyberway.mp.user.api.appinstance.dto.AppInstanceModifyBaseDto;
import com.cyberway.mp.user.api.appinstance.dto.AppInstanceModifyDto;
import com.cyberway.mp.user.api.appinstance.dto.AppInstancePageDto;
import com.cyberway.mp.user.api.appinstance.dto.AppInstanceReportPageSyncDto;
import com.cyberway.mp.user.api.appinstance.dto.AppInstanceTenantPageDto;
import com.cyberway.mp.user.api.appinstance.vo.AppFormPageResourceMenuVo;
import com.cyberway.mp.user.api.appinstance.vo.AppInstanceBaseInfoVo;
import com.cyberway.mp.user.api.appinstance.vo.AppInstanceInfoVo;
import com.cyberway.mp.user.api.appinstance.vo.AppInstanceListInfoVo;
import com.cyberway.mp.user.api.appinstance.vo.AppInstancePageResourceVo;
import com.cyberway.mp.user.api.appinstance.vo.AppInstanceResourceMinVo;
import com.cyberway.mp.user.api.appinstance.vo.AppInstanceTenantVo;
import com.cyberway.mp.user.api.appinstance.vo.MyAppInstanceGroup;
import com.cyberway.mp.user.api.appinstance.vo.MyAppInstanceListInfoVo;
import com.cyberway.mp.user.api.common.vo.IdNameVo;
import com.cyberway.mp.user.api.common.vo.SelectTreeNodeVo;
import com.cyberway.mp.user.api.constants.UserErrorCode;
import com.cyberway.mp.user.feign.client.AppInstanceClient;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class AppInstanceFeignService
implements AppInstanceApi {
    private final AppInstanceClient appInstanceClient;

    public AppInstanceFeignService(AppInstanceClient appInstanceClient) {
        this.appInstanceClient = appInstanceClient;
    }

    public void deleteInstanceAndTemplate(Long appInstanceId) {
        this.appInstanceClient.deleteInstanceAndTemplate(appInstanceId);
    }

    public long createAppInstance(AppInstanceCreateDto dto) {
        Long id = (Long)this.appInstanceClient.createAppInstance(dto).getData();
        if (id == null) {
            throw new BaseI18nException((ErrorCode)UserErrorCode.SYSTEM_ERROR);
        }
        return id;
    }

    public long createAppInstanceForTenant(AppInstanceCreateForTenantDto dto) {
        Long id = (Long)this.appInstanceClient.createAppInstanceForTenant(dto).getData();
        if (id == null) {
            throw new BaseI18nException((ErrorCode)UserErrorCode.SYSTEM_ERROR);
        }
        return id;
    }

    public void modifyAppInstance(AppInstanceModifyDto dto) {
        this.appInstanceClient.modifyAppInstance(dto.getId(), (AppInstanceModifyBaseDto)dto);
    }

    public AppInstanceInfoVo getAppInstance(long id) {
        return (AppInstanceInfoVo)this.appInstanceClient.getAppInstance(id).getData();
    }

    public void enableAppInstance(long id) {
        this.appInstanceClient.enableAppInstance(id);
    }

    public void disableAppInstance(long id) {
        this.appInstanceClient.disableAppInstance(id);
    }

    public Page<AppInstanceListInfoVo> queryAppInstance(AppInstancePageDto dto) {
        return (Page)this.appInstanceClient.queryAppInstance(dto).getData();
    }

    public void initAppInstance(AppInstanceInitDto dto) {
        this.appInstanceClient.initAppInstance(dto);
    }

    public void initAppInstanceMenu(AppInstanceMenuInitDto dto) {
        this.appInstanceClient.initAppInstanceMenu(dto);
    }

    public List<SelectTreeNodeVo> getAppInstancePageResourceTree(long appInstanceId) {
        return (List)this.appInstanceClient.getPageResourceTree(appInstanceId).getData();
    }

    public List<AppInstancePageResourceVo> getAppInstanceElementResourceTree(long appInstanceId) {
        return (List)this.appInstanceClient.getElementResourceTree(appInstanceId).getData();
    }

    public List<IdNameVo> listAppInstances() {
        return (List)this.appInstanceClient.listAppInstance().getData();
    }

    public List<MyAppInstanceListInfoVo> listMyAppInstances(Boolean containsDisabled) {
        return (List)this.appInstanceClient.listMyAppInstances(containsDisabled).getData();
    }

    public MyAppInstanceGroup groupMyAppInstances(Boolean containsDisabled) {
        return (MyAppInstanceGroup)this.appInstanceClient.groupMyAppInstances(containsDisabled).getData();
    }

    public Map<Long, List<Long>> getAppInstanceSelectedResources(long id) {
        return (Map)this.appInstanceClient.getAppInstanceSelectedResources(id).getData();
    }

    public List<MyAppInstanceListInfoVo> listByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return (List)this.appInstanceClient.listByIds(ids).getData();
    }

    public AppInstanceBaseInfoVo getAppBaseInfo(@Valid AppInstanceBaseInfoQueryDto dto) {
        return (AppInstanceBaseInfoVo)this.appInstanceClient.getAppBaseInfo(dto).getData();
    }

    public Page<AppInstanceListInfoVo> queryAppInstanceByTenantId(Long tenantId, AppInstancePageDto dto) {
        return (Page)this.appInstanceClient.queryAppInstanceByTenantId(tenantId, dto).getData();
    }

    public void syncDataEaseReportPage(AppInstanceReportPageSyncDto dto) {
        this.appInstanceClient.syncDataEaseReportPage(dto);
    }

    public void syncLowCodePage(AppInstanceLowCodePageSyncDto dto) {
        this.appInstanceClient.syncLowCodePage(dto);
    }

    public List<AppInstanceResourceMinVo> getAppInstanceResourceMinVos(Collection<Long> appInstanceResourceIds) {
        return (List)this.appInstanceClient.getAppInstanceResourceMinVo(new ArrayList<Long>(appInstanceResourceIds)).getData();
    }

    public AppFormPageResourceMenuVo getAppFormPageResourceMenuVo(AppFormPageResourceMenuDto dto) {
        return (AppFormPageResourceMenuVo)this.appInstanceClient.getAppFormPageResourceMenuVo(dto).getData();
    }

    public void importAppFormPageResourceMenu(AppFormPageResourceMenuImportDto dto) {
        this.appInstanceClient.importAppFormPageResourceMenu(dto);
    }

    public Page<AppInstanceTenantVo> pageWithTenantName(AppInstanceTenantPageDto dto) {
        return (Page)this.appInstanceClient.pageWithTenantName(dto).getData();
    }
}

