/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.user.feign.service;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.user.api.apptemplate.AppTemplateApi;
import com.cyberway.mp.user.api.apptemplate.dto.AppTemplateCreateDto;
import com.cyberway.mp.user.api.apptemplate.dto.AppTemplateInitInstanceDto;
import com.cyberway.mp.user.api.apptemplate.dto.AppTemplateInitLogPageDto;
import com.cyberway.mp.user.api.apptemplate.dto.AppTemplateModifyBaseDto;
import com.cyberway.mp.user.api.apptemplate.dto.AppTemplateModifyDto;
import com.cyberway.mp.user.api.apptemplate.dto.AppTemplatePageDto;
import com.cyberway.mp.user.api.apptemplate.dto.AppTemplatePageElementResourcePageDto;
import com.cyberway.mp.user.api.apptemplate.vo.AppTemplateInfoVo;
import com.cyberway.mp.user.api.apptemplate.vo.AppTemplateInitLogListVo;
import com.cyberway.mp.user.api.apptemplate.vo.AppTemplateInitLogVo;
import com.cyberway.mp.user.api.apptemplate.vo.AppTemplateSelectResourceTreeVo;
import com.cyberway.mp.user.api.apptemplate.vo.AppTemplateSimpleInfoVo;
import com.cyberway.mp.user.api.common.vo.SelectTreeNodeVo;
import com.cyberway.mp.user.api.constants.UserErrorCode;
import com.cyberway.mp.user.api.resource.vo.PageElementResourceInfoVo;
import com.cyberway.mp.user.feign.client.AppTemplateClient;
import java.util.List;

public class AppTemplateFeignService
implements AppTemplateApi {
    private final AppTemplateClient appTemplateClient;

    public AppTemplateFeignService(AppTemplateClient appTemplateClient) {
        this.appTemplateClient = appTemplateClient;
    }

    public long createAppTemplate(AppTemplateCreateDto dto) {
        Long id = (Long)this.appTemplateClient.createAppTemplate(dto).getData();
        if (id == null) {
            throw new BaseI18nException((ErrorCode)UserErrorCode.SYSTEM_ERROR);
        }
        return id;
    }

    public AppTemplateInfoVo getAppTemplate(long id) {
        return (AppTemplateInfoVo)this.appTemplateClient.getAppTemplate(id).getData();
    }

    public void modifyAppTemplate(AppTemplateModifyDto dto) {
        this.appTemplateClient.modifyAppTemplate(dto.getId(), (AppTemplateModifyBaseDto)dto);
    }

    public void enableAppTemplate(long id) {
        this.appTemplateClient.enableAppTemplate(id);
    }

    public void disableAppTemplate(long id) {
        this.appTemplateClient.disableAppTemplate(id);
    }

    public void deleteAppTemplate(long id) {
        this.appTemplateClient.deleteAppTemplate(id);
    }

    public Page<AppTemplateSimpleInfoVo> queryAppTemplate(AppTemplatePageDto dto) {
        return (Page)this.appTemplateClient.queryAppTemplate(dto).getData();
    }

    public List<AppTemplateSimpleInfoVo> listEnabledAppTemplate() {
        return (List)this.appTemplateClient.listEnabledAppTemplate().getData();
    }

    public List<SelectTreeNodeVo> getAppTemplatePageResourceTree(long appTemplateId) {
        return (List)this.appTemplateClient.getAppTemplatePageResourceTree(appTemplateId).getData();
    }

    public Page<PageElementResourceInfoVo> queryAppTemplatePageElementResource(AppTemplatePageElementResourcePageDto dto) {
        return (Page)this.appTemplateClient.queryAppTemplatePageElementResource(dto).getData();
    }

    public AppTemplateInitLogVo initInstances(AppTemplateInitInstanceDto dto) {
        return (AppTemplateInitLogVo)this.appTemplateClient.initInstances(dto).getData();
    }

    public List<AppTemplateSelectResourceTreeVo> templateResourceTree(long appTemplateId) {
        return (List)this.appTemplateClient.templateResourceTree(appTemplateId).getData();
    }

    public Page<AppTemplateInitLogListVo> queryInitLog(AppTemplateInitLogPageDto dto) {
        return (Page)this.appTemplateClient.queryInitLog(dto).getData();
    }

    public AppTemplateInitLogVo getInitLog(Long id) {
        return (AppTemplateInitLogVo)this.appTemplateClient.getInitLog(id).getData();
    }
}

