/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.user.feign.service;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.user.api.businesszone.BusinessZoneApi;
import com.cyberway.mp.user.api.businesszone.dto.BusinessZoneCreateDto;
import com.cyberway.mp.user.api.businesszone.dto.BusinessZoneModifyBaseDto;
import com.cyberway.mp.user.api.businesszone.dto.BusinessZoneModifyDto;
import com.cyberway.mp.user.api.businesszone.dto.BusinessZonePageDto;
import com.cyberway.mp.user.api.businesszone.vo.BusinessZoneInfoVo;
import com.cyberway.mp.user.api.businesszone.vo.BusinessZoneListInfoVo;
import com.cyberway.mp.user.api.constants.UserErrorCode;
import com.cyberway.mp.user.feign.client.BusinessZoneClient;
import java.util.Collections;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class BusinessZoneFeignService
implements BusinessZoneApi {
    private final BusinessZoneClient businessZoneClient;

    public BusinessZoneFeignService(BusinessZoneClient businessZoneClient) {
        this.businessZoneClient = businessZoneClient;
    }

    public long createBusinessZone(BusinessZoneCreateDto dto) {
        Long id = (Long)this.businessZoneClient.createBusinessZone(dto).getData();
        if (id == null) {
            throw new BaseI18nException((ErrorCode)UserErrorCode.SYSTEM_ERROR);
        }
        return id;
    }

    public void modifyBusinessZone(BusinessZoneModifyDto dto) {
        this.businessZoneClient.modifyBusinessZone(dto.getId(), (BusinessZoneModifyBaseDto)dto);
    }

    public BusinessZoneInfoVo getBusinessZone(long id) {
        return (BusinessZoneInfoVo)this.businessZoneClient.getBusinessZone(id).getData();
    }

    public BusinessZoneInfoVo getBusinessZoneByCode(long tenantId, String codeName) {
        return (BusinessZoneInfoVo)this.businessZoneClient.getBusinessZoneByCode(tenantId, codeName).getData();
    }

    public Page<BusinessZoneListInfoVo> queryBusinessZone(BusinessZonePageDto dto) {
        return (Page)this.businessZoneClient.queryBusinessZone(dto).getData();
    }

    public List<BusinessZoneInfoVo> listBusinessZone() {
        return (List)this.businessZoneClient.listBusinessZone().getData();
    }

    public List<BusinessZoneInfoVo> listBusinessZone(Long tenantId) {
        return (List)this.businessZoneClient.listBusinessZone(tenantId).getData();
    }

    public List<BusinessZoneInfoVo> listByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return (List)this.businessZoneClient.listByIds(ids).getData();
    }
}

