/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.user.feign.service;

import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.user.api.constants.UserErrorCode;
import com.cyberway.mp.user.api.menu.MenuApi;
import com.cyberway.mp.user.api.menu.dto.FormGroupDto;
import com.cyberway.mp.user.api.menu.dto.FormPageDto;
import com.cyberway.mp.user.api.menu.dto.MenuItemCreateDto;
import com.cyberway.mp.user.api.menu.dto.MenuItemModifyBaseDto;
import com.cyberway.mp.user.api.menu.dto.MenuItemModifyDto;
import com.cyberway.mp.user.api.menu.dto.MenuItemTreeModifyDto;
import com.cyberway.mp.user.api.menu.dto.MenuResourceBundleCreateDto;
import com.cyberway.mp.user.api.menu.vo.MenuItemInfoVo;
import com.cyberway.mp.user.api.menu.vo.MenuItemTreeNodeVo;
import com.cyberway.mp.user.api.menu.vo.MenuResourceTreeVo;
import com.cyberway.mp.user.feign.client.MenuClient;
import jakarta.validation.Valid;
import java.util.List;

public class MenuFeignService
implements MenuApi {
    private final MenuClient menuClient;

    public MenuFeignService(MenuClient menuClient) {
        this.menuClient = menuClient;
    }

    public long createMenuItem(MenuItemCreateDto dto) {
        Long id = (Long)this.menuClient.createMenuItem(dto).getData();
        if (id == null) {
            throw new BaseI18nException((ErrorCode)UserErrorCode.SYSTEM_ERROR);
        }
        return id;
    }

    public long createByFormGroup(FormGroupDto dto) {
        return (Long)this.menuClient.createByFormGroup(dto).getData();
    }

    public void syncByFormPage(FormPageDto dto) {
        this.menuClient.syncByFormPage(dto);
    }

    public void syncStatusByFormPage(long appInstanceId, long formPageId, int status) {
        this.menuClient.syncStatusByFormPage(appInstanceId, formPageId, status);
    }

    public void modifyMenuItem(MenuItemModifyDto dto) {
        this.menuClient.modifyMenuItem(dto.getId(), (MenuItemModifyBaseDto)dto);
    }

    public void modifyByFormGroup(FormGroupDto dto) {
        this.menuClient.modifyByFormGroup(dto);
    }

    public MenuItemInfoVo getMenuItem(long id) {
        return (MenuItemInfoVo)this.menuClient.getMenuItem(id).getData();
    }

    public List<MenuItemTreeNodeVo> getMenuItemTree(long appInstanceId) {
        return (List)this.menuClient.getMenuItemTree(appInstanceId).getData();
    }

    public List<MenuResourceTreeVo> getResourceTree(long appInstanceId) {
        return (List)this.menuClient.getResourceTree(appInstanceId).getData();
    }

    public void deleteMenuItem(long id) {
        this.menuClient.deleteMenuItem(id);
    }

    public void deleteByFormGroup(long groupId) {
        this.menuClient.deleteByFormGroup(groupId);
    }

    public void resortMenuItem(List<Long> sortedIds) {
        this.menuClient.resortMenuItem(sortedIds);
    }

    public void bundleCreateMenuResource(MenuResourceBundleCreateDto dto) {
        this.menuClient.bundleCreateMenuResource(dto);
    }

    public void modifyMenuItemTree(@Valid MenuItemTreeModifyDto dto) {
        this.menuClient.modifyMenuItemTree(dto);
    }

    public List<MenuItemInfoVo> listByIds(List<Long> ids) {
        return (List)this.menuClient.listByIds(ids).getData();
    }
}

