/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.user.feign.service;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.user.api.common.vo.IdNameVo;
import com.cyberway.mp.user.api.common.vo.SelectTreeNodeVo;
import com.cyberway.mp.user.api.constants.UserErrorCode;
import com.cyberway.mp.user.api.resource.ResourceApi;
import com.cyberway.mp.user.api.resource.dto.PageElementResourceCreateDto;
import com.cyberway.mp.user.api.resource.dto.PageElementResourceModifyBaseDto;
import com.cyberway.mp.user.api.resource.dto.PageElementResourceModifyDto;
import com.cyberway.mp.user.api.resource.dto.PageElementResourcePageDto;
import com.cyberway.mp.user.api.resource.dto.PageResourceCreateDto;
import com.cyberway.mp.user.api.resource.dto.PageResourceModifyBaseDto;
import com.cyberway.mp.user.api.resource.dto.PageResourceModifyDto;
import com.cyberway.mp.user.api.resource.dto.ResourceApiBindDto;
import com.cyberway.mp.user.api.resource.dto.ResourceApiUnbindDto;
import com.cyberway.mp.user.api.resource.dto.ResourceTreeModifyDto;
import com.cyberway.mp.user.api.resource.vo.EnabledResourceTreeVo;
import com.cyberway.mp.user.api.resource.vo.PageElementResourceInfoVo;
import com.cyberway.mp.user.api.resource.vo.PageElementResourceListVo;
import com.cyberway.mp.user.api.resource.vo.PageResourceInfoVo;
import com.cyberway.mp.user.api.resource.vo.ResourceApiVo;
import com.cyberway.mp.user.feign.client.ResourceClient;
import java.util.List;
import org.springframework.core.io.Resource;

public class ResourceFeignService
implements ResourceApi {
    private final ResourceClient resourceClient;

    public ResourceFeignService(ResourceClient resourceClient) {
        this.resourceClient = resourceClient;
    }

    public long createPageResource(PageResourceCreateDto dto) {
        Long id = (Long)this.resourceClient.createPageResource(dto).getData();
        if (id == null) {
            throw new BaseI18nException((ErrorCode)UserErrorCode.SYSTEM_ERROR);
        }
        return id;
    }

    public void modifyPageResource(PageResourceModifyDto dto) {
        this.resourceClient.modifyPageResource(dto.getId(), (PageResourceModifyBaseDto)dto);
    }

    public void deletePageResource(long id) {
        this.resourceClient.deletePageResource(id);
    }

    public PageResourceInfoVo getPageResource(long id) {
        return (PageResourceInfoVo)this.resourceClient.getPageResource(id).getData();
    }

    public void resortResource(List<Long> sortedIds) {
        this.resourceClient.resortPageResource(sortedIds);
    }

    public List<IdNameVo> getPageTreeChildren(Long parentId) {
        if (parentId == null) {
            return (List)this.resourceClient.getTreeChildren().getData();
        }
        return (List)this.resourceClient.getTreeChildren(parentId).getData();
    }

    public long createPageElementResource(PageElementResourceCreateDto dto) {
        Long id = (Long)this.resourceClient.createPageElementResource(dto).getData();
        if (id == null) {
            throw new BaseI18nException((ErrorCode)UserErrorCode.SYSTEM_ERROR);
        }
        return id;
    }

    public void modifyPageElementResource(PageElementResourceModifyDto dto) {
        this.resourceClient.modifyPageElementResource(dto.getId(), (PageElementResourceModifyBaseDto)dto);
    }

    public void deletePageElementResource(long id) {
        this.resourceClient.deletePageElementResource(id);
    }

    public void enablePageElementResource(long id) {
        this.resourceClient.enablePageElementResource(id);
    }

    public void disablePageElementResource(long id) {
        this.resourceClient.disablePageElementResource(id);
    }

    public PageElementResourceInfoVo getPageElementResource(long id) {
        return (PageElementResourceInfoVo)this.resourceClient.getPageElementResource(id).getData();
    }

    public Page<PageElementResourceListVo> queryPageElementResource(PageElementResourcePageDto dto) {
        return (Page)this.resourceClient.queryPageElementResource(dto).getData();
    }

    public List<SelectTreeNodeVo> getPageResourceTree() {
        return (List)this.resourceClient.getPageResourceTree().getData();
    }

    public List<EnabledResourceTreeVo> getEnabledResourceTree() {
        return (List)this.resourceClient.getEnabledResourceTree().getData();
    }

    public void bindPageApi(ResourceApiBindDto dto) {
        this.resourceClient.bindPageApi(dto);
    }

    public void bindElementViewApi(ResourceApiBindDto dto) {
        this.resourceClient.bindElementViewApi(dto);
    }

    public void bindElementActionApi(ResourceApiBindDto dto) {
        this.resourceClient.bindElementActionApi(dto);
    }

    public void unbindPageApi(ResourceApiUnbindDto dto) {
        this.resourceClient.unbindPageApi(dto);
    }

    public void unbindElementViewApi(ResourceApiUnbindDto dto) {
        this.resourceClient.unbindElementViewApi(dto);
    }

    public void unbindElementActionApi(ResourceApiUnbindDto dto) {
        this.resourceClient.unbindElementActionApi(dto);
    }

    public List<ResourceApiVo> listPageApi(long pageResourceId) {
        return (List)this.resourceClient.listPageApi(pageResourceId).getData();
    }

    public List<ResourceApiVo> listPageElementViewApi(long elementResourceId) {
        return (List)this.resourceClient.listPageElementViewApi(elementResourceId).getData();
    }

    public List<ResourceApiVo> listPageElementActionApi(long elementResourceId) {
        return (List)this.resourceClient.listPageElementActionApi(elementResourceId).getData();
    }

    public Resource getPageResourceImportTemplate() {
        throw new UnsupportedOperationException();
    }

    public void cleanCache() {
        this.resourceClient.cleanCache();
    }

    public void refreshApiResource() {
        throw new UnsupportedOperationException();
    }

    public void modifyResourceTree(ResourceTreeModifyDto dto) {
        this.resourceClient.modifyResourceTree(dto);
    }
}

