/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.user.feign.service;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.user.api.role.RoleApi;
import com.cyberway.mp.user.api.role.dto.RoleAppInstanceBindDto;
import com.cyberway.mp.user.api.role.dto.RoleAppInstanceModifyDto;
import com.cyberway.mp.user.api.role.dto.RoleBatchAddDto;
import com.cyberway.mp.user.api.role.dto.RoleCreateDto;
import com.cyberway.mp.user.api.role.dto.RoleHandoverDto;
import com.cyberway.mp.user.api.role.dto.RoleListSelectedMemberDto;
import com.cyberway.mp.user.api.role.dto.RoleMemberAddDto;
import com.cyberway.mp.user.api.role.dto.RoleMemberPageDto;
import com.cyberway.mp.user.api.role.dto.RoleMemberTimeConfigDto;
import com.cyberway.mp.user.api.role.dto.RoleMenuExportDto;
import com.cyberway.mp.user.api.role.dto.RoleModifyBaseDto;
import com.cyberway.mp.user.api.role.dto.RoleModifyDto;
import com.cyberway.mp.user.api.role.dto.RolePageDto;
import com.cyberway.mp.user.api.role.dto.RoleUserPageBaseDto;
import com.cyberway.mp.user.api.role.dto.RoleUserPageDto;
import com.cyberway.mp.user.api.role.dto.RoleUserQueryDto;
import com.cyberway.mp.user.api.role.dto.UserRoleQueryDto;
import com.cyberway.mp.user.api.role.vo.RoleAppInstanceListVo;
import com.cyberway.mp.user.api.role.vo.RoleDutyMemberVo;
import com.cyberway.mp.user.api.role.vo.RoleInfoVo;
import com.cyberway.mp.user.api.role.vo.RoleListInfoVo;
import com.cyberway.mp.user.api.role.vo.RoleMenuConfigTreeVo;
import com.cyberway.mp.user.api.role.vo.RoleMenuExportVo;
import com.cyberway.mp.user.api.role.vo.RoleOrgUnitMemberVo;
import com.cyberway.mp.user.api.role.vo.RoleUserInfoVo;
import com.cyberway.mp.user.api.role.vo.RoleUserMemberVo;
import com.cyberway.mp.user.api.role.vo.RoleUserVo;
import com.cyberway.mp.user.api.user.vo.UserRoleVo;
import com.cyberway.mp.user.feign.client.RoleClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RoleFeignService
implements RoleApi {
    private final RoleClient roleClient;

    public RoleFeignService(RoleClient roleClient) {
        this.roleClient = roleClient;
    }

    public long createRole(RoleCreateDto dto) {
        return (Long)this.roleClient.createRole(dto).getData();
    }

    public void modifyRole(RoleModifyDto dto) {
        this.roleClient.modifyRole(dto.getId(), (RoleModifyBaseDto)dto);
    }

    public void deleteRole(long id) {
        this.roleClient.deleteRole(id);
    }

    public void enableRole(long id) {
        this.roleClient.enableRole(id);
    }

    public void disableRole(long id) {
        this.roleClient.disableRole(id);
    }

    public Page<RoleListInfoVo> queryRole(RolePageDto dto) {
        return (Page)this.roleClient.queryRole(dto).getData();
    }

    public RoleInfoVo getRole(long id) {
        return (RoleInfoVo)this.roleClient.getRole(id).getData();
    }

    public long bindAppInstance(RoleAppInstanceBindDto dto) {
        return (Long)this.roleClient.bindAppInstance(dto).getData();
    }

    public void bindAppInstanceModify(RoleAppInstanceModifyDto dto) {
        this.roleClient.bindAppInstanceModify(dto);
    }

    public void bindAppInstanceDelete(long id) {
        this.roleClient.bindAppInstanceDelete(id);
    }

    public List<RoleAppInstanceListVo> bindAppInstanceList(long roleId) {
        return (List)this.roleClient.bindAppInstanceList(roleId).getData();
    }

    public List<Long> listAllMemberEntityIds(RoleListSelectedMemberDto dto) {
        return (List)this.roleClient.listAllMemberEntityIds(dto).getData();
    }

    public void configMemberTime(RoleMemberTimeConfigDto dto) {
        this.roleClient.configMemberTime(dto);
    }

    public void addRoleMembers(RoleMemberAddDto dto) {
        this.roleClient.addRoleMembers(dto);
    }

    public void handoverUserRole(List<RoleHandoverDto> dtoList) {
        this.roleClient.handoverUserRole(dtoList);
    }

    public void deleteRoleMember(long memberId) {
        this.roleClient.deleteRoleMember(memberId);
    }

    public void batchDeleteRoleMember(List<Long> memberIds) {
        this.roleClient.batchDeleteRoleMember(memberIds);
    }

    public void cleanRoleMemberByOrgUnitIds(List<Long> ids) {
        this.roleClient.cleanRoleMemberByOrgUnitIds(ids);
    }

    public void cleanRoleMemberByDutyIds(List<Long> ids) {
        this.roleClient.cleanRoleMemberByDutyIds(ids);
    }

    public Page<RoleUserInfoVo> queryRoleUser(RoleUserPageDto dto) {
        return (Page)this.roleClient.queryRoleUser(dto.getRoleId(), (RoleUserPageBaseDto)dto).getData();
    }

    public Page<RoleUserInfoVo> queryUserByRole(RoleUserPageDto dto) {
        return (Page)this.roleClient.queryRoleUser(dto.getRoleId(), (RoleUserPageBaseDto)dto).getData();
    }

    public List<Long> listEnabledRoleUserId(Collection<Long> roleIds) {
        return (List)this.roleClient.listEnabledRoleUserId(new ArrayList<Long>(roleIds)).getData();
    }

    public Page<RoleUserMemberVo> queryRoleUserMember(RoleMemberPageDto dto) {
        return (Page)this.roleClient.queryRoleUserMember(dto).getData();
    }

    public Page<RoleOrgUnitMemberVo> queryRoleOrgUnitMember(RoleMemberPageDto dto) {
        return (Page)this.roleClient.queryRoleOrgUnitMember(dto).getData();
    }

    public Page<RoleDutyMemberVo> queryRoleDutyMember(RoleMemberPageDto dto) {
        return (Page)this.roleClient.queryRoleDutyMember(dto).getData();
    }

    public RoleMenuExportVo exportRoleMenuData(RoleMenuExportDto dto) {
        return (RoleMenuExportVo)this.roleClient.exportRoleMenuData(dto).getData();
    }

    public void initUserRole() {
        this.roleClient.initUserRole();
    }

    public List<RoleMenuConfigTreeVo> getRoleMenuConfigTree(long appInstanceId) {
        return (List)this.roleClient.getRoleMenuConfigTree(appInstanceId).getData();
    }

    public List<RoleMenuConfigTreeVo> getRoleMenuConfigTreeForRole(long roleId, long appInstanceId) {
        return (List)this.roleClient.getRoleMenuConfigTreeForRole(roleId, appInstanceId).getData();
    }

    public List<UserRoleVo> checkUserHasRole(UserRoleQueryDto userRoleQueryDto) {
        return (List)this.roleClient.checkUserHasRole(userRoleQueryDto).getData();
    }

    public void batchAddRoles(RoleBatchAddDto roleMemberDto) {
        this.roleClient.batchAddRoles(roleMemberDto);
    }

    public List<RoleUserVo> listEnabledUserIdByRolesAndUsers(RoleUserQueryDto dto) {
        return (List)this.roleClient.listEnabledUserIdByRolesAndUsers(dto).getData();
    }

    public void mergeOrganization(List<Long> sourceOrgUnitId, Long targetOrgUnitId) {
    }
}

