/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.user.feign.service;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.user.api.appinstance.dto.AppInstanceCreateDto;
import com.cyberway.mp.user.api.appinstance.vo.AppInstanceListInfoVo;
import com.cyberway.mp.user.api.common.dto.ReasonDto;
import com.cyberway.mp.user.api.common.vo.IdNameVo;
import com.cyberway.mp.user.api.constants.UserErrorCode;
import com.cyberway.mp.user.api.tenant.TenantApi;
import com.cyberway.mp.user.api.tenant.dto.TenantAdminAddDto;
import com.cyberway.mp.user.api.tenant.dto.TenantAdminCreateDto;
import com.cyberway.mp.user.api.tenant.dto.TenantAdminModifyBaseDto;
import com.cyberway.mp.user.api.tenant.dto.TenantAdminModifyDto;
import com.cyberway.mp.user.api.tenant.dto.TenantAdminPageDto;
import com.cyberway.mp.user.api.tenant.dto.TenantAppInstancePageDto;
import com.cyberway.mp.user.api.tenant.dto.TenantAppTemplateAddDto;
import com.cyberway.mp.user.api.tenant.dto.TenantAppTemplateDisableDto;
import com.cyberway.mp.user.api.tenant.dto.TenantAppTemplateEnableDto;
import com.cyberway.mp.user.api.tenant.dto.TenantAppTemplateFullInfoManagerPageDto;
import com.cyberway.mp.user.api.tenant.dto.TenantAppTemplateFullInfoPageDto;
import com.cyberway.mp.user.api.tenant.dto.TenantCopyDto;
import com.cyberway.mp.user.api.tenant.dto.TenantCreateDto;
import com.cyberway.mp.user.api.tenant.dto.TenantHierarchicalAuthCloseDto;
import com.cyberway.mp.user.api.tenant.dto.TenantHierarchicalAuthOpenDto;
import com.cyberway.mp.user.api.tenant.dto.TenantManageModifyBaseDto;
import com.cyberway.mp.user.api.tenant.dto.TenantManageModifyDto;
import com.cyberway.mp.user.api.tenant.dto.TenantModifyBaseDto;
import com.cyberway.mp.user.api.tenant.dto.TenantModifyDto;
import com.cyberway.mp.user.api.tenant.dto.TenantPageDto;
import com.cyberway.mp.user.api.tenant.vo.TenantAdminInfoVo;
import com.cyberway.mp.user.api.tenant.vo.TenantAdminRoleInfoVo;
import com.cyberway.mp.user.api.tenant.vo.TenantAppTemplateFullInfoVo;
import com.cyberway.mp.user.api.tenant.vo.TenantCreatedVo;
import com.cyberway.mp.user.api.tenant.vo.TenantInfoVo;
import com.cyberway.mp.user.api.tenant.vo.TenantInitJobVo;
import com.cyberway.mp.user.api.tenant.vo.TenantShortNameVo;
import com.cyberway.mp.user.feign.client.TenantClient;
import java.util.List;

public class TenantFeignService
implements TenantApi {
    private final TenantClient tenantClient;

    public TenantFeignService(TenantClient tenantClient) {
        this.tenantClient = tenantClient;
    }

    public TenantCreatedVo createTenant(TenantCreateDto dto) {
        return (TenantCreatedVo)this.tenantClient.createTenant(dto).getData();
    }

    public TenantCreatedVo createTenantWithAppInstance(TenantCreateDto dto) {
        return (TenantCreatedVo)this.tenantClient.createTenantWithAppInstance(dto).getData();
    }

    public void addAppInstanceToTenant(long tenantId, AppInstanceCreateDto appInstanceCreateDto) {
        this.tenantClient.addAppInstanceToTenant(tenantId, appInstanceCreateDto);
    }

    public TenantCreatedVo copyTenant(TenantCopyDto dto) {
        return (TenantCreatedVo)this.tenantClient.copyTenant(dto).getData();
    }

    public List<TenantInitJobVo> listTenantInitJob(long tenantId) {
        return (List)this.tenantClient.listTenantInitJob(tenantId).getData();
    }

    public void reInitTenant(long tenantId, boolean skipInit, boolean initNotFailed) {
        this.tenantClient.reInitTenant(tenantId, skipInit, initNotFailed);
    }

    public void modifyTenant(TenantModifyDto dto) {
        this.tenantClient.modifyTenant(dto.getId(), (TenantModifyBaseDto)dto);
    }

    public TenantInfoVo getTenant(long id) {
        return (TenantInfoVo)this.tenantClient.getTenant(id).getData();
    }

    public TenantInfoVo getLoginTenant() {
        return (TenantInfoVo)this.tenantClient.getLoginTenant().getData();
    }

    public Page<TenantInfoVo> queryTenant(TenantPageDto dto) {
        return (Page)this.tenantClient.queryTenant(dto).getData();
    }

    public void enableTenant(long id) {
        this.tenantClient.enableTenant(id);
    }

    public void disableTenant(long id) {
        this.tenantClient.disableTenant(id);
    }

    public long createTenantAdmin(TenantAdminCreateDto dto) {
        Long id = (Long)this.tenantClient.createTenantAdmin(dto).getData();
        if (id == null) {
            throw new BaseI18nException((ErrorCode)UserErrorCode.SYSTEM_ERROR);
        }
        return id;
    }

    public void modifyTenantAdmin(TenantAdminModifyDto dto) {
        this.tenantClient.modifyTenantAdmin(dto.getId(), (TenantAdminModifyBaseDto)dto);
    }

    public void enableTenantAdmin(long adminId, String reason) {
        this.tenantClient.enableTenantAdmin(adminId, new ReasonDto(reason));
    }

    public void disableTenantAdmin(long adminId, String reason) {
        this.tenantClient.disableTenantAdmin(adminId, new ReasonDto(reason));
    }

    public TenantAdminInfoVo getTenantAdmin(long adminId) {
        return (TenantAdminInfoVo)this.tenantClient.getTenantAdmin(adminId).getData();
    }

    public Page<TenantAdminInfoVo> queryTenantAdmin(TenantAdminPageDto dto) {
        return (Page)this.tenantClient.queryTenantAdmin(dto).getData();
    }

    public void deleteTenantAdmin(long adminId) {
        this.tenantClient.deleteTenantAdmin(adminId);
    }

    public Page<AppInstanceListInfoVo> queryTenantAppInstance(TenantAppInstancePageDto dto) {
        return (Page)this.tenantClient.queryTenantAppInstance(dto).getData();
    }

    public void enableTenantAppInstance(long appInstanceId) {
        this.tenantClient.enableTenantAppInstance(appInstanceId);
    }

    public void disableTenantAppInstance(long appInstanceId) {
        this.tenantClient.disableTenantAppInstance(appInstanceId);
    }

    public void modifyManageTenant(TenantManageModifyDto dto) {
        this.tenantClient.modifyTenantManage(dto.getId(), (TenantManageModifyBaseDto)dto);
    }

    public List<IdNameVo> listEnabledTenant() {
        return (List)this.tenantClient.listEnabledTenant().getData();
    }

    public List<TenantShortNameVo> listMyTenant() {
        return (List)this.tenantClient.listMyTenant().getData();
    }

    public void addAppTemplateToTenant(TenantAppTemplateAddDto dto) {
        this.tenantClient.addAppTemplateToTenant(dto);
    }

    public Page<TenantAppTemplateFullInfoVo> queryAppTemplateFullInfo(TenantAppTemplateFullInfoPageDto dto) {
        return (Page)this.tenantClient.queryAppTemplateFullInfo(dto).getData();
    }

    public Page<TenantAppTemplateFullInfoVo> managerQueryAppTemplateFullInfo(TenantAppTemplateFullInfoManagerPageDto dto) {
        return (Page)this.tenantClient.managerQueryAppTemplateFullInfo(dto).getData();
    }

    public void disableTenantAppTemplate(TenantAppTemplateDisableDto dto) {
        this.tenantClient.disableTenantAppTemplate(dto);
    }

    public void enableTenantAppTemplate(TenantAppTemplateEnableDto dto) {
        this.tenantClient.enableTenantAppTemplate(dto);
    }

    public List<IdNameVo> listSelectableAppTemplate() {
        return (List)this.tenantClient.listSelectableAppTemplate().getData();
    }

    public void openHierarchicalAuth(TenantHierarchicalAuthOpenDto dto) {
        this.tenantClient.openHierarchicalAuth(dto);
    }

    public void closeHierarchicalAuth(TenantHierarchicalAuthCloseDto dto) {
        this.tenantClient.closeHierarchicalAuth(dto);
    }

    public TenantAdminRoleInfoVo getTenantAdminRole(long tenantId) {
        return (TenantAdminRoleInfoVo)this.tenantClient.getTenantAdminRole(tenantId).getData();
    }

    public void addTenantAdmin(TenantAdminAddDto dto) {
        this.tenantClient.addTenantAdmin(dto);
    }
}

