/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.user.feign.service;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.user.api.user.UserBindingApi;
import com.cyberway.mp.user.api.user.dto.UserBindingAddUserDto;
import com.cyberway.mp.user.api.user.dto.UserBindingDto;
import com.cyberway.mp.user.api.user.dto.UserBindingQueryDto;
import com.cyberway.mp.user.api.user.dto.UserUnBindDto;
import com.cyberway.mp.user.api.user.vo.UserBindingVo;
import com.cyberway.mp.user.feign.client.UserBindingClient;
import jakarta.validation.Valid;
import java.util.List;

public class UserBindingFeignService
implements UserBindingApi {
    private final UserBindingClient client;

    public UserBindingFeignService(UserBindingClient client) {
        this.client = client;
    }

    public long binding(@Valid UserBindingDto dto) {
        return (Long)this.client.binding(dto).getData();
    }

    public void batchBinding(@Valid List<UserBindingDto> dtoList) {
        this.client.batchBinding(dtoList);
    }

    public List<UserBindingVo> queryBingingInfo(UserBindingQueryDto dto) {
        return (List)this.client.queryBingingInfo(dto).getData();
    }

    public Page<UserBindingVo> pageBingingInfo(UserBindingQueryDto dto) {
        return (Page)this.client.pageBingingInfo(dto).getData();
    }

    public List<UserBindingVo> getBingingInfoByUser(long userId) {
        return (List)this.client.getBingingInfoByUser(userId).getData();
    }

    public List<UserBindingVo> getBingingInfoByType(String type) {
        return (List)this.client.getBingingInfoByType(type).getData();
    }

    public List<UserBindingVo> getBingingInfoByAppId(String appId) {
        return (List)this.client.getBingingInfoByAppId(appId).getData();
    }

    public List<UserBindingVo> getBingingInfoByTargetId(String targetId) {
        return (List)this.client.getBingingInfoByTargetId(targetId).getData();
    }

    public void unbind(long id) {
        this.client.unbind(id);
    }

    public void batchUnbind(List<Long> ids) {
        this.client.batchUnbind(ids);
    }

    public void unbind(@Valid UserUnBindDto dto) {
        this.client.unbindByQuery(dto);
    }

    public void addBindUser(UserBindingAddUserDto dto) {
        this.client.addBindUser(dto);
    }
}

