/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.user.feign.service;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.user.api.common.dto.ReasonDto;
import com.cyberway.mp.user.api.constants.UserErrorCode;
import com.cyberway.mp.user.api.role.dto.AllRoleQueryDto;
import com.cyberway.mp.user.api.role.vo.AllRoleInfoVo;
import com.cyberway.mp.user.api.role.vo.RoleSimpleInfoVo;
import com.cyberway.mp.user.api.user.UserApi;
import com.cyberway.mp.user.api.user.dto.MyUserInfoModifyDto;
import com.cyberway.mp.user.api.user.dto.UserBaseInfoModifyDto;
import com.cyberway.mp.user.api.user.dto.UserBindingLoginDto;
import com.cyberway.mp.user.api.user.dto.UserCreateDto;
import com.cyberway.mp.user.api.user.dto.UserCreateForBindingDto;
import com.cyberway.mp.user.api.user.dto.UserEmailLoginDto;
import com.cyberway.mp.user.api.user.dto.UserExportDto;
import com.cyberway.mp.user.api.user.dto.UserExtPageDto;
import com.cyberway.mp.user.api.user.dto.UserIdLoginDto;
import com.cyberway.mp.user.api.user.dto.UserIdsDto;
import com.cyberway.mp.user.api.user.dto.UserLoginDto;
import com.cyberway.mp.user.api.user.dto.UserMobileLoginDto;
import com.cyberway.mp.user.api.user.dto.UserModifyDto;
import com.cyberway.mp.user.api.user.dto.UserPageDto;
import com.cyberway.mp.user.api.user.dto.UserPasswordCheckDto;
import com.cyberway.mp.user.api.user.dto.UserPasswordModifyBaseDto;
import com.cyberway.mp.user.api.user.dto.UserPasswordModifyDto;
import com.cyberway.mp.user.api.user.dto.UserRegisterDto;
import com.cyberway.mp.user.api.user.dto.UserRoleDto;
import com.cyberway.mp.user.api.user.dto.UserRoleHistoryYearRespDto;
import com.cyberway.mp.user.api.user.dto.UserSyncDto;
import com.cyberway.mp.user.api.user.enums.UserRoleUpdateType;
import com.cyberway.mp.user.api.user.vo.LoginMenuResourceTreeVo;
import com.cyberway.mp.user.api.user.vo.MyUserInfoVo;
import com.cyberway.mp.user.api.user.vo.UserDutyRoleMemberVo;
import com.cyberway.mp.user.api.user.vo.UserInfoVo;
import com.cyberway.mp.user.api.user.vo.UserListInfoVo;
import com.cyberway.mp.user.api.user.vo.UserLoginInfoVo;
import com.cyberway.mp.user.api.user.vo.UserOrgUnitRoleMemberVo;
import com.cyberway.mp.user.api.user.vo.UserRoleExportVo;
import com.cyberway.mp.user.api.user.vo.UserRoleMemberVo;
import com.cyberway.mp.user.api.user.vo.UserWithBindingVo;
import com.cyberway.mp.user.api.user.vo.UserWithExtendInfoVo;
import com.cyberway.mp.user.api.user.vo.UserWithRoleAndEmployeeVo;
import com.cyberway.mp.user.api.user.vo.UserWithRoleVo;
import com.cyberway.mp.user.api.user.vo.UserWithUserRoleVo;
import com.cyberway.mp.user.feign.client.UserClient;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class UserFeignService
implements UserApi {
    private final UserClient userClient;

    public UserFeignService(UserClient userClient) {
        this.userClient = userClient;
    }

    public long createUser(UserCreateDto dto) {
        Long id = (Long)this.userClient.createUser(dto).getData();
        if (id == null) {
            throw new BaseI18nException((ErrorCode)UserErrorCode.SYSTEM_ERROR);
        }
        return id;
    }

    public void modifyUser(UserModifyDto dto) {
        this.userClient.modifyUser(dto.getId(), dto);
    }

    public void modifyBaseUserInfo(UserBaseInfoModifyDto dto) {
        this.userClient.modifyBaseUserInfo(dto.getId(), dto);
    }

    public void modifyMyUserInfo(MyUserInfoModifyDto dto) {
        this.userClient.modifyMyUserInfo(dto);
    }

    public UserInfoVo registerUser(UserRegisterDto userRegisterDto) {
        return (UserInfoVo)this.userClient.registerUser(userRegisterDto).getData();
    }

    public UserLoginInfoVo login(UserLoginDto userLoginDto) {
        return (UserLoginInfoVo)this.userClient.login(userLoginDto).getData();
    }

    public UserLoginInfoVo mobileLogin(UserMobileLoginDto dto) {
        return (UserLoginInfoVo)this.userClient.mobileLogin(dto).getData();
    }

    public UserLoginInfoVo emailLogin(UserEmailLoginDto dto) {
        return (UserLoginInfoVo)this.userClient.emailLogin(dto).getData();
    }

    public UserLoginInfoVo userBindingLogin(UserBindingLoginDto dto) {
        return (UserLoginInfoVo)this.userClient.userBindingLogin(dto).getData();
    }

    public UserLoginInfoVo userIdLogin(UserIdLoginDto dto) {
        return (UserLoginInfoVo)this.userClient.userIdLogin(dto).getData();
    }

    public UserInfoVo getUserByLoginName(String loginName) {
        return (UserInfoVo)this.userClient.getUserByLoginName(loginName).getData();
    }

    public UserInfoVo getUserByMobile(String mobile) {
        return (UserInfoVo)this.userClient.getUserByMobile(mobile).getData();
    }

    public List<UserInfoVo> getUserByMobiles(List<String> mobiles) {
        return (List)this.userClient.getUserByMobiles(mobiles).getData();
    }

    public UserInfoVo getUserByEmail(String email) {
        return (UserInfoVo)this.userClient.getUserByEmail(email).getData();
    }

    public List<UserInfoVo> getUserByEmails(List<String> emails) {
        return (List)this.userClient.getUserByEmails(emails).getData();
    }

    public void updatePassword(UserPasswordModifyDto dto) {
        this.userClient.updatePassword(dto.getId(), (UserPasswordModifyBaseDto)dto);
    }

    public UserInfoVo getUser(long id) {
        return (UserInfoVo)this.userClient.getUser(id).getData();
    }

    public UserWithRoleAndEmployeeVo getUserWithRoleAndEmployee(long id) {
        return (UserWithRoleAndEmployeeVo)this.userClient.getUserWithRoleAndEmployee(id).getData();
    }

    public UserWithUserRoleVo getUserWithUserRole(Long userId) {
        return (UserWithUserRoleVo)this.userClient.getUserWithUserRole(userId).getData();
    }

    public UserWithExtendInfoVo getUserWithExtendInfo(long id) {
        return (UserWithExtendInfoVo)this.userClient.getUserWithExtendInfo(id).getData();
    }

    public Page<UserListInfoVo> queryUser(UserPageDto dto) {
        return (Page)this.userClient.queryUser(dto).getData();
    }

    public Page<UserListInfoVo> queryAllUser(UserPageDto dto) {
        return (Page)this.userClient.queryAllUser(dto).getData();
    }

    public Page<UserListInfoVo> queryUserWithoutBindingEmployee(UserPageDto dto) {
        return (Page)this.userClient.queryUserWithoutBindingEmployee(dto).getData();
    }

    public Page<UserListInfoVo> queryUserWithoutBindingTenant(UserPageDto dto) {
        return (Page)this.userClient.queryUserWithoutBindingTenant(dto).getData();
    }

    public void addUserToCurrentTenant(UserIdsDto dto) {
        this.userClient.addUserToCurrentTenant(dto);
    }

    public void removeUserFromCurrentTenant(UserIdsDto dto) {
        this.userClient.removeUserFromCurrentTenant(dto);
    }

    public void enableUser(long id, String reason) {
        this.userClient.enableUser(id, new ReasonDto(reason));
    }

    public void disableUser(long id, String reason) {
        this.userClient.disableUser(id, new ReasonDto(reason));
    }

    public void deleteUser(long id) {
        this.userClient.deleteUser(id);
    }

    public void batchDeleteUser(Set<Long> ids) {
        this.userClient.batchDeleteUser(ids);
    }

    public boolean checkLoginNameExisted(String loginName) {
        return (Boolean)this.userClient.checkLoginNameExisted(loginName).getData();
    }

    public boolean checkEmailExisted(String email) {
        return (Boolean)this.userClient.checkEmailExisted(email).getData();
    }

    public boolean checkMobileExisted(String mobile) {
        return (Boolean)this.userClient.checkMobileExisted(mobile).getData();
    }

    public List<LoginMenuResourceTreeVo> getLoginUserMenuTree(long appInstanceId) {
        return (List)this.userClient.getLoginUserMenuTree(appInstanceId).getData();
    }

    public List<RoleSimpleInfoVo> listLoginUserRoles(Long appInstanceId) {
        return (List)this.userClient.listLoginUserRoles(appInstanceId).getData();
    }

    public void loginUserRolesDataAuth() {
        this.userClient.loginUserRolesDataAuth();
    }

    public Set<Long> getLoginUserApiIds() {
        return (Set)this.userClient.getLoginUserApiIds().getData();
    }

    public Set<String> getLoginUserApiCodes() {
        return (Set)this.userClient.getLoginUserApiCodes().getData();
    }

    public MyUserInfoVo getMyUserInfo() {
        return (MyUserInfoVo)this.userClient.getMyUserInfo().getData();
    }

    public List<UserRoleMemberVo> listUserRole(long id) {
        return (List)this.userClient.listUserRole(id).getData();
    }

    public List<UserDutyRoleMemberVo> listDutyRole(long id) {
        return (List)this.userClient.listDutyRole(id).getData();
    }

    public List<UserOrgUnitRoleMemberVo> listOrgUnitRole(long id) {
        return (List)this.userClient.listOrgUnitRole(id).getData();
    }

    public boolean checkPassword(UserPasswordCheckDto dto) {
        return (Boolean)this.userClient.checkPassword(dto).getData();
    }

    public List<UserRoleExportVo> listUserRoleExportData(UserPageDto dto) {
        return (List)this.userClient.listUserRoleExportData(dto).getData();
    }

    public List<UserInfoVo> listByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(ids = ids.stream().filter(id -> id != null && !id.equals(0L)).collect(Collectors.toList()))) {
            return Collections.emptyList();
        }
        return (List)this.userClient.listByIds(ids).getData();
    }

    public List<UserInfoVo> listByLoginNames(Collection<String> loginNames) {
        return (List)this.userClient.listByLoginNames(new ArrayList<String>(loginNames)).getData();
    }

    public void updateLang(String lang) {
        this.userClient.updateLang(lang);
    }

    public Map<Long, String> getLoginNameMap(Collection<Long> ids) {
        return (Map)this.userClient.getLoginNameMap(new ArrayList<Long>(ids)).getData();
    }

    public Map<Long, String> getNameMap(Collection<Long> ids) {
        return (Map)this.userClient.getNameMap(new ArrayList<Long>(ids)).getData();
    }

    public Map<Long, String> getNameOrLoginNameMap(Collection<Long> ids) {
        return (Map)this.userClient.getNameOrLoginNameMap(new ArrayList<Long>(ids)).getData();
    }

    public List<Long> filterEnabled(Collection<Long> ids) {
        return (List)this.userClient.filterEnabled(new ArrayList<Long>(ids)).getData();
    }

    public List<AllRoleInfoVo> allRoleList(Long userId, AllRoleQueryDto allRoleQueryDto) {
        return (List)this.userClient.allRoleList(userId, allRoleQueryDto).getData();
    }

    public void addUserRoleByMemberEntityIds(Long userId, List<Long> memberEntityIds) {
        this.userClient.addUserRoleByMemberEntityIds(userId, memberEntityIds);
    }

    public List<UserRoleHistoryYearRespDto> queryYear(Long userId) {
        return (List)this.userClient.queryYear(userId).getData();
    }

    public UserWithBindingVo getUserWithBinding(Long id) {
        return (UserWithBindingVo)this.userClient.getUserWithBinding(id).getData();
    }

    public List<UserWithBindingVo> listUserWithBindingByIds(List<Long> ids) {
        return (List)this.userClient.listUserWithBindingByIds(ids).getData();
    }

    public Long syncUser(UserSyncDto userSyncDto) {
        return (Long)this.userClient.syncUser(userSyncDto).getData();
    }

    public UserWithRoleVo getUserWithRole(Long id) {
        return (UserWithRoleVo)this.userClient.getUserWithRole(id).getData();
    }

    public void addUserRoles(Map<Long, List<UserRoleDto>> userId2UserRoles) {
        this.userClient.addUserRoles(userId2UserRoles);
    }

    public void updateUserRole(Long userId, Collection<Long> ids, UserRoleUpdateType userRoleUpdateType) {
        this.userClient.updateUserRole(userId, userRoleUpdateType, ids);
    }

    public void removeUserRoleByMemberEntityIds(Long userId, List<Long> entityIds) {
        this.userClient.removeUserRoleByMemberEntityIds(userId, entityIds);
    }

    public void resetUserRole(Long userId) {
        this.userClient.resetUserRole(userId);
    }

    public void exportUser(UserExportDto dto, HttpServletResponse response) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Long> countWorkbenchInfo(Integer countType) {
        return (Map)this.userClient.countWorkbenchInfo(countType).getData();
    }

    public Page<UserListInfoVo> queryUserByExtCondition(UserExtPageDto dto) {
        return (Page)this.userClient.queryUserByExtCondition(dto).getData();
    }

    public long countAllUser() {
        return (Long)this.userClient.countAllUser().getData();
    }

    public List<RoleSimpleInfoVo> listSelectRoles() {
        return (List)this.userClient.listSelectRoles().getData();
    }

    public List<Long> listEnabledUserIdInOrgUnitAndHasRole(Long orgUnitId, String roleCode) {
        return (List)this.userClient.listEnabledUserIdInOrgUnitAndHasRole(orgUnitId, roleCode).getData();
    }

    public List<Long> listEnabledUserIdByOrgUnitCodeAndHasRole(String orgUnitCode, String roleCode) {
        return (List)this.userClient.listEnabledUserIdByOrgUnitCodeAndHasRole(orgUnitCode, roleCode).getData();
    }

    public List<Long> listUserIdByRoleCodes(Collection<String> roleCodes) {
        return (List)this.userClient.listUserIdByRoleCodes(new HashSet<String>(roleCodes)).getData();
    }

    public long createUserForBinding(UserCreateForBindingDto dto) {
        return (Long)this.userClient.createUserForBinding(dto).getData();
    }

    public Map<Long, String> getEmailMap(Collection<Long> ids) {
        return (Map)this.userClient.getEmailMap(new ArrayList<Long>(ids)).getData();
    }

    public void initLoginUserCache() {
        this.userClient.initLoginUserCache();
    }

    public List<Long> listAllUserId() {
        return (List)this.userClient.listAllUserId().getData();
    }
}

