/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.basic.data.api.systemsetting.vo;

import com.cyberway.mp.basic.data.api.systemsetting.CurrencyFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

@Schema
public class LocalizationDetailVo {
    private static final String UNDERLINE = "_";
    @Schema(title="\u533a\u57df")
    private Locale location = Locale.getDefault();
    @Schema(title="\u8bed\u8a00")
    private Locale language = Locale.getDefault();
    @Schema(title="\u65f6\u533a")
    private TimeZone timeZone = TimeZone.getDefault();
    @Schema(title="\u8d27\u5e01\u683c\u5f0f")
    private CurrencyFormat currencyFormat = new CurrencyFormat();

    public LocalizationDetailVo(String location, String language, String timeZone) {
        if (StringUtils.isNotEmpty((CharSequence)location)) {
            this.location = this.createLocale(location);
        }
        if (StringUtils.isNotEmpty((CharSequence)language)) {
            this.language = this.createLocale(language);
        }
        if (StringUtils.isNotEmpty((CharSequence)timeZone)) {
            this.timeZone = TimeZone.getTimeZone(timeZone);
        }
    }

    private Locale createLocale(String location) {
        if (location.contains(UNDERLINE)) {
            return new Locale(StringUtils.substringBefore((String)location, (String)UNDERLINE), StringUtils.substringAfter((String)location, (String)UNDERLINE));
        }
        return new Locale(location);
    }

    public Locale getLocation() {
        return this.location;
    }

    public void setLocation(Locale location) {
        this.location = location;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public CurrencyFormat getCurrencyFormat() {
        return this.currencyFormat;
    }

    public void setCurrencyFormat(CurrencyFormat currencyFormat) {
        this.currencyFormat = currencyFormat;
    }
}

