/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.rule.tree.buildpids;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.rule.tree.buildpids.BasePidBuildModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PidStructureBuildUtil {
    public static <T extends BasePidBuildModel> void createPidStructure(List<T> list2) {
        String parentPids;
        HashMap<String, String> routeMap = new HashMap<String, String>();
        HashMap<String, BasePidBuildModel> waitMap = new HashMap<String, BasePidBuildModel>();
        for (BasePidBuildModel itemModel : list2) {
            String pid = itemModel.pidBuildParentId();
            String pids = "";
            if (ObjectUtil.isEmpty((Object)pid) || "-1".equals(pid)) {
                pids = "[-1],";
                itemModel.setPidBuildPidStructure(pids);
                routeMap.put(itemModel.pidBuildNodeId(), pids);
                continue;
            }
            parentPids = (String)routeMap.get(pid);
            if (ObjectUtil.isEmpty((Object)parentPids)) {
                waitMap.put(itemModel.pidBuildNodeId(), itemModel);
                continue;
            }
            pids = parentPids + "[" + pid + "]" + ",";
            itemModel.setPidBuildPidStructure(pids);
            routeMap.put(itemModel.pidBuildNodeId(), pids);
        }
        int size = waitMap.size();
        while (size != 0) {
            Iterator iterator = waitMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                BasePidBuildModel waitProcessItem = (BasePidBuildModel)entry.getValue();
                parentPids = (String)routeMap.get(waitProcessItem.pidBuildParentId());
                if (ObjectUtil.isEmpty((Object)parentPids)) continue;
                String pids = parentPids + "[" + waitProcessItem.pidBuildParentId() + "]" + ",";
                waitProcessItem.setPidBuildPidStructure(pids);
                routeMap.put(waitProcessItem.pidBuildNodeId(), pids);
                --size;
                iterator.remove();
            }
        }
    }
}

