/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.parse;

import com.ql.util.express.exception.QLCompileException;
import com.ql.util.express.match.IDataNode;
import com.ql.util.express.match.INodeType;
import com.ql.util.express.parse.NodeType;
import java.util.ArrayList;
import java.util.List;

public class ExpressNode
implements IDataNode {
    private NodeType nodeType;
    private NodeType treeType;
    private String value;
    private String originalValue;
    private Object objectValue;
    private ExpressNode parent;
    private List<ExpressNode> children = new ArrayList<ExpressNode>();
    private int line;
    private int col;

    public ExpressNode(NodeType nodeType, String value) throws Exception {
        this(nodeType, value, null, null, null, -1, -1);
    }

    public ExpressNode(NodeType nodeType, String value, String originalValue, Object objectValue, NodeType treeType, int line, int col) throws Exception {
        if (nodeType == null) {
            throw new QLCompileException(value + " \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8282\u70b9\u7c7b\u578b");
        }
        this.nodeType = nodeType;
        this.treeType = treeType;
        if (value != null && value.length() > 0) {
            this.value = value;
        }
        if (originalValue != null && originalValue.length() > 0) {
            this.originalValue = originalValue;
        }
        if (objectValue != null) {
            this.objectValue = objectValue;
        }
        this.line = line;
        this.col = col;
    }

    public boolean isTypeEqualsOrChild(String parent) {
        boolean result = this.getTreeType().isEqualsOrChild(parent);
        if (!result && this.treeType != null) {
            result = this.getNodeType().isEqualsOrChild(parent);
        }
        return result;
    }

    @Override
    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            return this.nodeType.getName();
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getInstructionFactory() {
        if (this.nodeType.getInstructionFactory() != null) {
            return this.nodeType.getInstructionFactory();
        }
        if (this.treeType != null && this.treeType.getInstructionFactory() != null) {
            return this.treeType.getInstructionFactory();
        }
        throw new RuntimeException("\u6ca1\u6709\u5b9a\u4e49\u8282\u70b9\u7684\u6307\u4ee4InstructionFactory\u4fe1\u606f\uff1a" + this.nodeType.getName() + (this.treeType == null ? "" : " \u6216\u8005 " + this.treeType.getName()));
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public void setOriginalValue(String originalValue) {
        this.originalValue = originalValue;
    }

    public Object getObjectValue() {
        return this.objectValue;
    }

    @Override
    public void setObjectValue(Object objectValue) {
        this.objectValue = objectValue;
    }

    public ExpressNode getParent() {
        return this.parent;
    }

    public void setParent(ExpressNode parent) {
        this.parent = parent;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public NodeType getRealTreeType() {
        return this.treeType;
    }

    @Override
    public NodeType getTreeType() {
        if (this.treeType == null) {
            return this.nodeType;
        }
        return this.treeType;
    }

    public void setTreeType(NodeType treeType) {
        this.treeType = treeType;
    }

    public List<ExpressNode> getChildrenList() {
        return this.children;
    }

    public void addChild(ExpressNode child) {
        if (child == null) {
            return;
        }
        this.children.add(child);
    }

    public ExpressNode[] getChildrenArray() {
        return this.children.toArray(new ExpressNode[0]);
    }

    public String toString() {
        return (this.originalValue == null ? this.getValue() : this.originalValue) + (this.nodeType.getName() == null ? "" : ":" + this.nodeType.getName());
    }

    @Override
    public IDataNode createExpressNode(INodeType iNodeType, String value) throws Exception {
        return new ExpressNode((NodeType)iNodeType, value);
    }

    @Override
    public void setNodeType(INodeType iNodeType) {
        this.setNodeType((NodeType)iNodeType);
    }

    @Override
    public void addChild(IDataNode ref) {
        this.addChild((ExpressNode)ref);
    }

    @Override
    public void setTreeType(INodeType iNodeType) {
        this.setTreeType((NodeType)iNodeType);
    }
}

