/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;

public class NacosPropertySource
extends MapPropertySource {
    private final String group;
    private final String dataId;
    private final Date timestamp;
    private final boolean isRefreshable;

    NacosPropertySource(String group, String dataId, Map<String, Object> source, Date timestamp, boolean isRefreshable) {
        super(String.join((CharSequence)",", dataId, group), source);
        this.group = group;
        this.dataId = dataId;
        this.timestamp = timestamp;
        this.isRefreshable = isRefreshable;
    }

    public NacosPropertySource(List<PropertySource<?>> propertySources, String group, String dataId, Date timestamp, boolean isRefreshable) {
        this(group, dataId, NacosPropertySource.getSourceMap(group, dataId, propertySources), timestamp, isRefreshable);
    }

    private static Map<String, Object> getSourceMap(String group, String dataId, List<PropertySource<?>> propertySources) {
        Iterator<PropertySource<?>> iterator;
        PropertySource<?> propertySource;
        if (CollectionUtils.isEmpty(propertySources)) {
            return Collections.emptyMap();
        }
        if (propertySources.size() == 1 && (propertySource = propertySources.get(0)) != null && (iterator = propertySource.getSource()) instanceof Map) {
            Map source = (Map)((Object)iterator);
            return source;
        }
        LinkedHashMap<String, Object> sourceMap = new LinkedHashMap<String, Object>();
        ArrayList otherTypePropertySources = new ArrayList();
        for (PropertySource<?> propertySource2 : propertySources) {
            if (propertySource2 == null) continue;
            if (propertySource2 instanceof MapPropertySource) {
                MapPropertySource mapPropertySource = (MapPropertySource)propertySource2;
                Map source = (Map)mapPropertySource.getSource();
                sourceMap.putAll(source);
                continue;
            }
            otherTypePropertySources.add(propertySource2);
        }
        if (!otherTypePropertySources.isEmpty()) {
            sourceMap.put(String.join((CharSequence)",", dataId, group), otherTypePropertySources);
        }
        return sourceMap;
    }

    public String getGroup() {
        return this.group;
    }

    public String getDataId() {
        return this.dataId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public boolean isRefreshable() {
        return this.isRefreshable;
    }
}

