/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow;

import com.alibaba.csp.sentinel.cluster.TokenResult;
import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent.CurrentConcurrencyManager;
import com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent.TokenCacheNode;
import com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent.TokenCacheNodeManager;
import com.alibaba.csp.sentinel.cluster.server.log.ClusterServerStatLogUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import java.util.concurrent.atomic.AtomicInteger;

public final class ConcurrentClusterFlowChecker {
    public static double calcGlobalThreshold(FlowRule rule) {
        double count = rule.getCount();
        switch (rule.getClusterConfig().getThresholdType()) {
            case 1: {
                return count;
            }
        }
        int connectedCount = ClusterFlowRuleManager.getConnectedCount(rule.getClusterConfig().getFlowId());
        return count * (double)connectedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TokenResult acquireConcurrentToken(String clientAddress, FlowRule rule, int acquireCount) {
        long flowId = rule.getClusterConfig().getFlowId();
        AtomicInteger nowCalls = CurrentConcurrencyManager.get(flowId);
        if (nowCalls == null) {
            RecordLog.warn((String)"[ConcurrentClusterFlowChecker] Fail to get nowCalls by flowId<{}>", (Object[])new Object[]{flowId});
            return new TokenResult(Integer.valueOf(-1));
        }
        if ((double)(nowCalls.get() + acquireCount) > ConcurrentClusterFlowChecker.calcGlobalThreshold(rule)) {
            ClusterServerStatLogUtil.log("concurrent|block|" + flowId, acquireCount);
            return new TokenResult(Integer.valueOf(1));
        }
        AtomicInteger atomicInteger = nowCalls;
        synchronized (atomicInteger) {
            if ((double)(nowCalls.get() + acquireCount) > ConcurrentClusterFlowChecker.calcGlobalThreshold(rule)) {
                ClusterServerStatLogUtil.log("concurrent|block|" + flowId, acquireCount);
                return new TokenResult(Integer.valueOf(1));
            }
            nowCalls.getAndAdd(acquireCount);
        }
        ClusterServerStatLogUtil.log("concurrent|pass|" + flowId, acquireCount);
        TokenCacheNode node = TokenCacheNode.generateTokenCacheNode(rule, acquireCount, clientAddress);
        TokenCacheNodeManager.putTokenCacheNode(node.getTokenId(), node);
        TokenResult tokenResult = new TokenResult(Integer.valueOf(0));
        tokenResult.setTokenId(node.getTokenId().longValue());
        return tokenResult;
    }

    public static TokenResult releaseConcurrentToken(long tokenId) {
        TokenCacheNode node = TokenCacheNodeManager.getTokenCacheNode(tokenId);
        if (node == null) {
            RecordLog.info((String)"[ConcurrentClusterFlowChecker] Token<{}> is already released", (Object[])new Object[]{tokenId});
            return new TokenResult(Integer.valueOf(7));
        }
        FlowRule rule = ClusterFlowRuleManager.getFlowRuleById(node.getFlowId());
        if (rule == null) {
            RecordLog.info((String)"[ConcurrentClusterFlowChecker] Fail to get rule by flowId<{}>", (Object[])new Object[]{node.getFlowId()});
            return new TokenResult(Integer.valueOf(3));
        }
        if (TokenCacheNodeManager.removeTokenCacheNode(tokenId) == null) {
            RecordLog.info((String)"[ConcurrentClusterFlowChecker] Token<{}> is already released for flowId<{}>", (Object[])new Object[]{tokenId, node.getFlowId()});
            return new TokenResult(Integer.valueOf(7));
        }
        int acquireCount = node.getAcquireCount();
        AtomicInteger nowCalls = CurrentConcurrencyManager.get(node.getFlowId());
        nowCalls.getAndAdd(-1 * acquireCount);
        ClusterServerStatLogUtil.log("concurrent|release|" + rule.getClusterConfig().getFlowId(), acquireCount);
        return new TokenResult(Integer.valueOf(6));
    }
}

