/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class AutoRefreshDataSource<S, T>
extends AbstractDataSource<S, T> {
    private ScheduledExecutorService service;
    protected long recommendRefreshMs = 3000L;

    public AutoRefreshDataSource(Converter<S, T> configParser) {
        super(configParser);
        this.startTimerService();
    }

    public AutoRefreshDataSource(Converter<S, T> configParser, long recommendRefreshMs) {
        super(configParser);
        if (recommendRefreshMs <= 0L) {
            throw new IllegalArgumentException("recommendRefreshMs must > 0, but " + recommendRefreshMs + " get");
        }
        this.recommendRefreshMs = recommendRefreshMs;
        this.startTimerService();
    }

    private void startTimerService() {
        this.service = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("sentinel-datasource-auto-refresh-task", true));
        this.service.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!AutoRefreshDataSource.this.isModified()) {
                        return;
                    }
                    Object newValue = AutoRefreshDataSource.this.loadConfig();
                    AutoRefreshDataSource.this.getProperty().updateValue(newValue);
                }
                catch (Throwable e) {
                    RecordLog.info((String)"loadConfig exception", (Throwable)e);
                }
            }
        }, this.recommendRefreshMs, this.recommendRefreshMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws Exception {
        if (this.service != null) {
            this.service.shutdownNow();
            this.service = null;
        }
    }

    protected boolean isModified() {
        return true;
    }
}

