/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage;

import com.alibaba.simpleimage.ImageFormat;
import com.alibaba.simpleimage.ImageRender;
import com.alibaba.simpleimage.SimpleImageException;
import com.alibaba.simpleimage.io.ByteArrayOutputStream;
import com.alibaba.simpleimage.render.DrawTextParameter;
import com.alibaba.simpleimage.render.DrawTextRender;
import com.alibaba.simpleimage.render.ReadRender;
import com.alibaba.simpleimage.render.ScaleParameter;
import com.alibaba.simpleimage.render.ScaleRender;
import com.alibaba.simpleimage.render.WriteRender;
import com.alibaba.simpleimage.util.ImageUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

@Deprecated
public final class CompositeImageProcessor {
    public static final int FILE_CONTENT_LOG_MAX_FILE_NUM = 50;
    public static final String FILE_CONTENT_LOG_BASE_DIR_NAME = "ibankErrorLog4FileContent";
    public static final long EXPIRED_PERIOD = 604800000L;
    private String errorDir = null;

    public CompositeImageProcessor(String errorDir) {
        this.setErrorDir(errorDir);
    }

    public CompositeImageProcessor() {
    }

    public OutputStream process(InputStream inputStream, DrawTextParameter drawParam, int maxWidth, int maxHeight) throws SimpleImageException {
        ImageRender wr = null;
        ByteArrayOutputStream output = null;
        try {
            inputStream = ImageUtils.createMemoryStream(inputStream);
            output = new ByteArrayOutputStream();
            ImageFormat outputFormat = ImageUtils.isGIF(inputStream) ? ImageFormat.GIF : ImageFormat.JPEG;
            ScaleParameter scaleParam = new ScaleParameter(maxWidth, maxHeight, ScaleParameter.Algorithm.AUTO);
            ReadRender rr = new ReadRender(inputStream, true);
            DrawTextRender dtr = new DrawTextRender(rr, drawParam);
            ScaleRender sr = new ScaleRender(dtr, scaleParam);
            wr = new WriteRender((ImageRender)sr, (OutputStream)output, outputFormat);
            wr.render();
        }
        catch (Exception e) {
            this.errorLog(inputStream);
            IOUtils.closeQuietly((OutputStream)output);
            if (e instanceof SimpleImageException) {
                throw (SimpleImageException)e;
            }
            throw new SimpleImageException(e);
        }
        finally {
            try {
                if (wr != null) {
                    wr.dispose();
                }
            }
            catch (SimpleImageException ignore) {}
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void errorLog(InputStream is) {
        if (StringUtils.isBlank((String)this.errorDir)) {
            this.errorDir = System.getProperty("java.io.tmpdir") + File.separator + FILE_CONTENT_LOG_BASE_DIR_NAME;
        }
        if (StringUtils.isNotBlank((String)this.errorDir)) {
            File errorPath = new File(this.errorDir);
            if (!errorPath.exists()) {
                errorPath.mkdirs();
            }
            if (!this.canWriteErrorDir(errorPath)) {
                return;
            }
            if (errorPath.exists() && is.markSupported()) {
                FileOutputStream os = null;
                try {
                    is.reset();
                    File temp = new File(errorPath, "errimg-" + UUID.randomUUID().toString().replace("-", "_") + ".jpg");
                    os = new FileOutputStream(temp);
                    byte[] buffer = new byte[1024];
                    int count = -1;
                    while ((count = is.read(buffer)) != -1) {
                        ((OutputStream)os).write(buffer, 0, count);
                    }
                    os.flush();
                }
                catch (IOException igonre) {
                    IOUtils.closeQuietly(os);
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(os);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
    }

    private boolean canWriteErrorDir(File errorPath) {
        String[] files = errorPath.list();
        if (files != null && files.length > 50) {
            long now = System.currentTimeMillis();
            int delNum = 0;
            for (String filename : files) {
                File errImg = new File(errorPath, filename);
                if (now - errImg.lastModified() <= 604800000L) continue;
                errImg.delete();
                ++delNum;
            }
            return files.length - delNum <= 50;
        }
        return true;
    }

    public String getErrorDir() {
        return this.errorDir;
    }

    public void setErrorDir(String errorDir) {
        this.errorDir = errorDir;
        File errorPath = new File(errorDir);
        if (!errorPath.exists()) {
            errorPath.mkdirs();
        }
    }

    static {
        ImageIO.setUseCache(false);
    }
}

