/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.record;

import com.aliyun.dts.subscribe.clients.record.RecordField;
import com.aliyun.dts.subscribe.clients.record.RecordIndexInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class ForeignKeyIndexInfo
extends RecordIndexInfo {
    final String parentSchema;
    final String parentDatabase;
    final String parentTable;
    final TreeMap<String, RecordField> referencedColumn;

    public ForeignKeyIndexInfo(RecordIndexInfo.IndexType type, String parentSchema, String parentDatabase, String parentTable) {
        super(type);
        this.parentSchema = parentSchema;
        this.parentDatabase = parentDatabase;
        this.parentTable = parentTable;
        this.referencedColumn = new TreeMap();
    }

    public String getParentSchema() {
        return this.parentSchema;
    }

    public void addConstraintField(String parentColumn, RecordField currentField) {
        this.referencedColumn.put(parentColumn, currentField);
        super.addField(currentField);
    }

    public String getParentTable() {
        return this.parentTable;
    }

    public String getParentDatabase() {
        return this.parentDatabase;
    }

    @Override
    public List<RecordField> getIndexFields() {
        LinkedList<RecordField> ret = new LinkedList<RecordField>();
        this.referencedColumn.forEach((k, v) -> ret.add((RecordField)v));
        return ret;
    }
}

