/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.destroyer;

import com.baomidou.dynamic.datasource.destroyer.DataSourceActiveDetector;
import com.baomidou.dynamic.datasource.destroyer.DataSourceDestroyer;
import com.baomidou.dynamic.datasource.destroyer.Dhcp2DataSourceActiveDetector;
import com.baomidou.dynamic.datasource.destroyer.DruidDataSourceActiveDetector;
import com.baomidou.dynamic.datasource.destroyer.HikariDataSourceActiveDetector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class DefaultDataSourceDestroyer
implements DataSourceDestroyer {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataSourceDestroyer.class);
    private static final String THREAD_NAME = "close-datasource";
    private static final long TIMEOUT_CLOSE = 10000L;
    private final List<DataSourceActiveDetector> detectors = new LinkedList<DataSourceActiveDetector>();

    public DefaultDataSourceDestroyer() {
        this.detectors.add(new HikariDataSourceActiveDetector());
        this.detectors.add(new DruidDataSourceActiveDetector());
        this.detectors.add(new Dhcp2DataSourceActiveDetector());
    }

    @Override
    public void asyncDestroy(String name, DataSource dataSource) {
        log.info("dynamic-datasource start asynchronous task to close the datasource named [{}],", (Object)name);
        ExecutorService executor = Executors.newSingleThreadExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setName(THREAD_NAME);
            return thread;
        });
        executor.execute(() -> this.graceDestroy(name, dataSource));
        executor.shutdown();
    }

    private void graceDestroy(String name, DataSource dataSource) {
        try {
            DataSourceActiveDetector detector = this.detectors.stream().filter(x -> x.support(dataSource)).findFirst().orElse(null);
            long start = System.currentTimeMillis();
            while ((detector == null || detector.containsActiveConnection(dataSource)) && System.currentTimeMillis() - start <= 10000L) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (Exception e) {
            log.warn("dynamic-datasource check the datasource named [{}] contains active connection failed,", (Object)name, (Object)e);
        }
        this.destroy(name, dataSource);
    }

    @Override
    public void destroy(String name, DataSource realDataSource) {
        Class<?> clazz = realDataSource.getClass();
        try {
            Method closeMethod = ReflectionUtils.findMethod(clazz, (String)"close");
            if (closeMethod != null) {
                closeMethod.invoke((Object)realDataSource, new Object[0]);
                log.info("dynamic-datasource close the datasource named [{}] success,", (Object)name);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.warn("dynamic-datasource close the datasource named [{}] failed,", (Object)name, (Object)e);
        }
    }
}

