/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.event;

import com.baomidou.dynamic.datasource.creator.DataSourceProperty;
import com.baomidou.dynamic.datasource.event.DataSourceInitEvent;
import com.baomidou.dynamic.datasource.toolkit.CryptoUtils;
import com.baomidou.dynamic.datasource.toolkit.DsStrUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncDataSourceInitEvent
implements DataSourceInitEvent {
    private static final Logger log = LoggerFactory.getLogger(EncDataSourceInitEvent.class);
    private static final Pattern ENC_PATTERN = Pattern.compile("^ENC\\((.*)\\)$");

    @Override
    public void beforeCreate(DataSourceProperty dataSourceProperty) {
        String publicKey = dataSourceProperty.getPublicKey();
        if (DsStrUtils.hasText((CharSequence)publicKey)) {
            dataSourceProperty.setUrl(this.decrypt(publicKey, dataSourceProperty.getUrl()));
            dataSourceProperty.setUsername(this.decrypt(publicKey, dataSourceProperty.getUsername()));
            dataSourceProperty.setPassword(this.decrypt(publicKey, dataSourceProperty.getPassword()));
        }
    }

    @Override
    public void afterCreate(DataSource dataSource) {
    }

    private String decrypt(String publicKey, String cipherText) {
        Matcher matcher;
        if (DsStrUtils.hasText((CharSequence)cipherText) && (matcher = ENC_PATTERN.matcher(cipherText)).find()) {
            try {
                return CryptoUtils.decrypt((String)publicKey, (String)matcher.group(1));
            }
            catch (Exception e) {
                log.error("DynamicDataSourceProperties.decrypt error ", (Throwable)e);
            }
        }
        return cipherText;
    }
}

