/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.ddl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.ddl.DdlScriptErrorHandler;
import com.baomidou.mybatisplus.extension.ddl.history.IDdlGenerator;
import com.baomidou.mybatisplus.extension.ddl.history.MysqlDdlGenerator;
import com.baomidou.mybatisplus.extension.ddl.history.OracleDdlGenerator;
import com.baomidou.mybatisplus.extension.ddl.history.PostgreDdlGenerator;
import com.baomidou.mybatisplus.extension.ddl.history.SQLiteDdlGenerator;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.jdbc.SqlRunner;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class DdlHelper {
    private static final Log LOG = LogFactory.getLog(DdlHelper.class);

    public static void runScript(IDdlGenerator ddlGenerator, Connection connection, List<String> sqlFiles, boolean autoCommit) throws SQLException {
        DdlHelper.runScript(ddlGenerator, connection, sqlFiles, autoCommit, (DdlScriptErrorHandler)DdlScriptErrorHandler.PrintlnLogErrorHandler.INSTANCE);
    }

    public static void runScript(IDdlGenerator ddlGenerator, Connection connection, List<String> sqlFiles, boolean autoCommit, DdlScriptErrorHandler ddlScriptErrorHandler) throws SQLException {
        DdlHelper.runScript(ddlGenerator, connection, sqlFiles, null, autoCommit, ddlScriptErrorHandler);
    }

    public static void runScript(IDdlGenerator ddlGenerator, Connection connection, List<String> sqlFiles, Consumer<ScriptRunner> scriptRunnerConsumer, DdlScriptErrorHandler ddlScriptErrorHandler) throws SQLException {
        DdlHelper.runScript(ddlGenerator, connection, sqlFiles, scriptRunnerConsumer, false, ddlScriptErrorHandler);
    }

    public static void runScript(IDdlGenerator ddlGenerator, Connection connection, List<String> sqlFiles, Consumer<ScriptRunner> scriptRunnerConsumer, boolean autoCommit, DdlScriptErrorHandler ddlScriptErrorHandler) throws SQLException {
        String jdbcUrl = connection.getMetaData().getURL();
        SqlRunner sqlRunner = new SqlRunner(connection);
        ScriptRunner scriptRunner = DdlHelper.getScriptRunner(connection, autoCommit);
        if (scriptRunnerConsumer != null) {
            scriptRunnerConsumer.accept(scriptRunner);
        }
        if (null == ddlGenerator) {
            ddlGenerator = DdlHelper.getDdlGenerator(jdbcUrl);
        }
        if (!ddlGenerator.existTable(connection)) {
            scriptRunner.runScript((Reader)new StringReader(ddlGenerator.createDdlHistory()));
        }
        for (String sqlFile : sqlFiles) {
            try {
                List objectMap = sqlRunner.selectAll(ddlGenerator.selectDdlHistory(sqlFile, "sql"), new Object[0]);
                if (null != objectMap && !objectMap.isEmpty()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Run script file: " + sqlFile);
                }
                String[] sqlFileArr = sqlFile.split("#");
                if (Objects.equals(2, sqlFileArr.length)) {
                    scriptRunner.setDelimiter(sqlFileArr[1]);
                    sqlFile = sqlFileArr[0];
                } else {
                    scriptRunner.setDelimiter(";");
                }
                File file = new File(sqlFile);
                if (file.exists()) {
                    scriptRunner.runScript((Reader)new FileReader(file));
                } else {
                    scriptRunner.runScript((Reader)new InputStreamReader(DdlHelper.getInputStream(sqlFile)));
                }
                sqlRunner.insert(ddlGenerator.insertDdlHistory(sqlFile, "sql", DdlHelper.getNowTime()), new Object[0]);
            }
            catch (Exception e) {
                if (ddlScriptErrorHandler == null) continue;
                ddlScriptErrorHandler.handle(sqlFile, e);
            }
        }
    }

    @Deprecated
    public static void runScript(IDdlGenerator ddlGenerator, DataSource dataSource, List<String> sqlFiles, boolean autoCommit) {
        try (Connection connection = dataSource.getConnection();){
            DdlHelper.runScript(ddlGenerator, connection, sqlFiles, autoCommit);
        }
        catch (Exception e) {
            LOG.error("Run script error: ", (Throwable)e);
        }
    }

    public static void runScript(IDdlGenerator ddlGenerator, DataSource dataSource, List<String> sqlFiles, boolean autoCommit, DdlScriptErrorHandler ddlScriptErrorHandler) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            DdlHelper.runScript(ddlGenerator, connection, sqlFiles, autoCommit, ddlScriptErrorHandler);
        }
    }

    public static void runScript(IDdlGenerator ddlGenerator, DataSource dataSource, List<String> sqlFiles, Consumer<ScriptRunner> scriptRunnerConsumer, DdlScriptErrorHandler ddlScriptErrorHandler) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            DdlHelper.runScript(ddlGenerator, connection, sqlFiles, scriptRunnerConsumer, false, ddlScriptErrorHandler);
        }
    }

    public static void runScript(IDdlGenerator ddlGenerator, DataSource dataSource, List<String> sqlFiles, Consumer<ScriptRunner> scriptRunnerConsumer, boolean autoCommit, DdlScriptErrorHandler ddlScriptErrorHandler) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            DdlHelper.runScript(ddlGenerator, connection, sqlFiles, scriptRunnerConsumer, autoCommit, ddlScriptErrorHandler);
        }
    }

    public static InputStream getInputStream(String path) throws Exception {
        return Resources.getResourceAsStream((String)path);
    }

    protected static String getNowTime() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm"));
    }

    public static ScriptRunner getScriptRunner(Connection connection, boolean autoCommit) {
        ScriptRunner scriptRunner = new ScriptRunner(connection);
        scriptRunner.setAutoCommit(autoCommit);
        scriptRunner.setEscapeProcessing(false);
        scriptRunner.setRemoveCRs(true);
        scriptRunner.setStopOnError(true);
        scriptRunner.setFullLineDelimiter(false);
        return scriptRunner;
    }

    protected static IDdlGenerator getDdlGenerator(String jdbcUrl) throws RuntimeException {
        DbType dbType = JdbcUtils.getDbType(jdbcUrl);
        if (dbType.mysqlSameType()) {
            return MysqlDdlGenerator.newInstance();
        }
        if (dbType.oracleSameType()) {
            return OracleDdlGenerator.newInstance();
        }
        if (DbType.SQLITE == dbType) {
            return SQLiteDdlGenerator.newInstance();
        }
        if (dbType.postgresqlSameType()) {
            return PostgreDdlGenerator.newInstance();
        }
        throw new RuntimeException("Unsupported database type: " + jdbcUrl);
    }

    public static String getDatabase(String jdbcUrl) {
        String[] dataArr;
        String[] urlArr = jdbcUrl.split("://");
        if (urlArr.length == 2 && (dataArr = urlArr[1].split("/")).length > 1) {
            return dataArr[1].split("\\?")[0];
        }
        return null;
    }
}

