/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.ddl.history;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.ddl.history.IDdlGenerator;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Function;

public class OracleDdlGenerator
implements IDdlGenerator {
    private String schema;

    public OracleDdlGenerator() {
    }

    public OracleDdlGenerator(String schema) {
        this.schema = schema;
    }

    public static IDdlGenerator newInstance() {
        return new OracleDdlGenerator();
    }

    @Override
    public boolean existTable(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        String schema = StringUtils.isNotBlank((CharSequence)this.schema) ? this.schema : connection.getSchema();
        String tableName = this.getDdlHistory();
        int index = tableName.lastIndexOf(".");
        if (index > 0) {
            tableName = tableName.substring(index + 1);
        }
        tableName = tableName.replace("\"", "");
        try (ResultSet resultSet = metaData.getTables(connection.getCatalog(), schema, tableName, new String[]{"TABLE"});){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    @Override
    public boolean existTable(String databaseName, Function<String, Boolean> executeFunction) {
        return executeFunction.apply("SELECT COUNT(1) AS NUM FROM user_tables WHERE table_name='" + this.getDdlHistory() + "'");
    }

    @Override
    public String getDdlHistory() {
        if (StringUtils.isNotBlank((CharSequence)this.schema)) {
            return this.schema + ".DDL_HISTORY";
        }
        return "DDL_HISTORY";
    }

    @Override
    public String createDdlHistory() {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ").append(this.getDdlHistory()).append("(");
        sql.append("script NVARCHAR2(500) NOT NULL,");
        sql.append("type NVARCHAR2(30) NOT NULL,");
        sql.append("version NVARCHAR2(30) NOT NULL");
        sql.append(");");
        return sql.toString();
    }
}

