/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.msf.commons.cache;

import com.ctg.itrdc.cache.pool.Constant;
import com.ctg.itrdc.cache.pool.CtgJedisPool;
import com.ctg.itrdc.cache.pool.ProxyJedis;
import com.cyberway.msf.commons.cache.CtgRedisException;
import com.cyberway.msf.commons.cache.RedisUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import redis.clients.jedis.exceptions.JedisDataException;

public class CtgRedisUtils
implements RedisUtils {
    private final CtgJedisPool ctgJedisPool;
    private final Environment environment;
    private final JdkSerializationRedisSerializer serializer;

    public CtgRedisUtils(CtgJedisPool ctgJedisPool, Environment environment) {
        this.ctgJedisPool = ctgJedisPool;
        this.environment = environment;
        this.serializer = new JdkSerializationRedisSerializer();
    }

    @Override
    public void setOrigin(String key, Object value) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.set(this.getByteOriginKey(key), this.serializer.serialize(value));
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    @Override
    public void setOrigin(String key, Object value, long time) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.setex(this.getByteOriginKey(key), (int)time, this.serializer.serialize(value));
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean setIfAbsentOrigin(String key, Object value) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Long result = jedis.setnx(this.getByteOriginKey(key), this.serializer.serialize(value));
            Boolean bl = result != null && result > 0L;
            return bl;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean setIfAbsentOrigin(String key, Object value, long time) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            boolean success;
            byte[] byteKey = this.getByteOriginKey(key);
            Long result = jedis.setnx(byteKey, this.serializer.serialize(value));
            boolean bl = success = result != null && result > 0L;
            if (success) {
                jedis.expire(byteKey, (int)time);
            }
            Boolean bl2 = success;
            return bl2;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean setIfPresentOrigin(String key, Object value) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            byte[] byteKey = this.getByteOriginKey(key);
            if (Boolean.TRUE.equals(jedis.exists(byteKey))) {
                jedis.set(this.getKey(key).getBytes(StandardCharsets.UTF_8), this.serializer.serialize(value));
                Boolean bl = true;
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean setIfPresentOrigin(String key, Object value, long time) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            byte[] byteKey = this.getByteOriginKey(key);
            if (Boolean.TRUE.equals(jedis.exists(byteKey))) {
                jedis.setex(this.getKey(key).getBytes(StandardCharsets.UTF_8), (int)time, this.serializer.serialize(value));
                Boolean bl = true;
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getOrigin(String key) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Object object = this.serializer.deserialize(jedis.get(this.getByteOriginKey(key)));
            return object;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    @Override
    public Object getOrigin(String key, boolean allowLocalCache) {
        return this.getOrigin(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long generate(String key) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            long l = jedis.incr(this.getByteOriginKey(this.getKey(key)));
            return l;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long generate(String key, Date expireTime) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            byte[] byteOriginKey = this.getByteOriginKey(this.getKey(key));
            Long result = jedis.incr(byteOriginKey);
            jedis.expireAt(byteOriginKey, expireTime.getTime());
            long l = result;
            return l;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long generate(String key, int increment) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            long l = jedis.incrBy(this.getByteOriginKey(this.getKey(key)), (long)increment);
            return l;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long generate(String key, int increment, Date expireTime) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            byte[] byteOriginKey = this.getByteOriginKey(this.getKey(key));
            Long result = jedis.incrBy(byteOriginKey, (long)increment);
            jedis.expireAt(byteOriginKey, expireTime.getTime());
            long l = result;
            return l;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long delOrigin(String ... key) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Long l = jedis.del((byte[][])Arrays.stream(key).map(this::getByteOriginKey).toArray(x$0 -> new byte[x$0][]));
            return l;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long getExpire(String key) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Long l = jedis.ttl(this.getKey(key));
            return l;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long getExpireOrigin(String key) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Long l = jedis.ttl(key);
            return l;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long getExpire(String key, TimeUnit timeUnit) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Long pttl = jedis.pttl(this.getKey(key));
            Long l = timeUnit.convert(pttl, TimeUnit.MILLISECONDS);
            return l;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long getExpireOrigin(String key, TimeUnit timeUnit) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Long pttl = jedis.pttl(key);
            Long l = timeUnit.convert(pttl, TimeUnit.MILLISECONDS);
            return l;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    @Override
    public void putHashOrigin(String key, Object hashKey, Object value) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.hset(this.getByteOriginKey(key), this.serializer.serialize(hashKey), this.serializer.serialize(value));
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    @Override
    public Object getHashOrigin(String key, Object hashKey) {
        return null;
    }

    @Override
    public void delHashOrigin(String key, Object ... hashKeys) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.hdel(this.getByteOriginKey(key), (byte[][])Arrays.stream(hashKeys).map(arg_0 -> ((JdkSerializationRedisSerializer)this.serializer).serialize(arg_0)).toArray(x$0 -> new byte[x$0][]));
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<Object> hashKeysOrigin(String key) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Set<Object> set = jedis.hkeys(this.getByteOriginKey(key)).stream().map(arg_0 -> ((JdkSerializationRedisSerializer)this.serializer).deserialize(arg_0)).collect(Collectors.toSet());
            return set;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<Object, Object> entriesHashOrigin(String key) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Map map = jedis.hgetAll(this.getByteOriginKey(key));
            if (map == null) {
                Map<Object, Object> map2 = Collections.emptyMap();
                return map2;
            }
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (Map.Entry entry : map.entrySet()) {
                result.put(this.serializer.deserialize((byte[])entry.getKey()), this.serializer.deserialize((byte[])entry.getValue()));
            }
            HashMap<Object, Object> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long listLeftPushOrigin(String key, Object value) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Long l = jedis.lpush(this.getByteOriginKey(key), (byte[][])new byte[][]{this.serializer.serialize(value)});
            return l;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long listRightPushOrigin(String key, Object value) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Long l = jedis.rpush(this.getByteOriginKey(key), (byte[][])new byte[][]{this.serializer.serialize(value)});
            return l;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object listLeftPopOrigin(String key) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Object object = this.serializer.deserialize(jedis.lpop(this.getByteOriginKey(key)));
            return object;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object listRightPopOrigin(String key) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Object object = this.serializer.deserialize(jedis.rpop(this.getByteOriginKey(key)));
            return object;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean expireOrigin(String key, long time) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Long result = jedis.expire(this.getByteOriginKey(key), (int)time);
            Boolean bl = result != null && result > 0L;
            return bl;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    @Override
    public boolean lock(String key, long time) {
        return this.lockOrigin(this.generateLockKey(key), time);
    }

    @Override
    public void unlock(String key) {
        this.unlockOrigin(this.generateLockKey(key));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean lockOrigin(String key, long time) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.lock(key, UUID.randomUUID().toString(), time * 1000L, 0L);
            boolean bl = true;
            return bl;
        }
        catch (JedisDataException e) {
            return false;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    @Override
    public void unlockOrigin(String key) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            jedis.del(Constant.DEFAULT_LOCK_PRE + key);
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    @Override
    public Boolean hasKey(String key) {
        return this.hasKeyOrigin(this.getKey(key));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean hasKeyOrigin(String key) {
        try (ProxyJedis jedis = this.ctgJedisPool.getResource();){
            Boolean bl = jedis.exists(this.getByteOriginKey(key));
            return bl;
        }
        catch (Exception e) {
            throw new CtgRedisException(e);
        }
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public RedisSerializer<?> getValueSerializer() {
        return this.serializer;
    }

    protected byte[] getByteOriginKey(String key) {
        return key.getBytes(StandardCharsets.UTF_8);
    }
}

