/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils;

import com.dtyunxi.cube.dto.TimeSlotDto;
import com.dtyunxi.cube.enhance.param.ICubeParam;
import com.dtyunxi.util.JacksonUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;

public class Util {
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public static Type readValueType(Class<? extends ICubeParam<?>> codeClass) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = codeClass.getGenericInterfaces()) {
            if (!(genericInterface instanceof ParameterizedType)) continue;
            Type[] actualTypeArguments = ((ParameterizedType)genericInterface).getActualTypeArguments();
            if (actualTypeArguments != null && actualTypeArguments.length == 1) {
                return actualTypeArguments[0];
            }
            throw new RuntimeException(codeClass + "\u57fa\u4e8eICubeParam\u7684\u6cdb\u578b\u6ca1\u6709\u6307\u5b9a\u7ed3\u679c\u7c7b\u578b");
        }
        throw new RuntimeException(codeClass + "\u6ca1\u6709\u5b9e\u73b0ICubeParam");
    }

    public static Class<?> readGenericParamType(Class<?> codeClass) {
        Type[] genericInterfaces = codeClass.getGenericInterfaces();
        if (null != genericInterfaces && genericInterfaces.length > 0) {
            for (Type genericInterface : genericInterfaces) {
                if (!(genericInterface instanceof ParameterizedType)) continue;
                Type[] actualTypeArguments = ((ParameterizedType)genericInterface).getActualTypeArguments();
                if (actualTypeArguments != null && actualTypeArguments.length > 0) {
                    Type arguType = actualTypeArguments[0];
                    return (Class)(arguType instanceof ParameterizedType ? ((ParameterizedType)arguType).getRawType() : arguType);
                }
                throw new RuntimeException(codeClass + "\u6cdb\u578b\u6ca1\u6709\u6307\u5b9a\u503c\u7c7b\u578b");
            }
        }
        throw new RuntimeException(codeClass + "\u6ca1\u6709\u5b9e\u73b0interface");
    }

    public static Class<?> getComponentType(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            return actualTypeArguments != null && actualTypeArguments.length == 1 ? (Class)actualTypeArguments[0] : null;
        }
        return (Class)type;
    }

    public static <T> T getT(Class<?> valueClass, String respValue) {
        Object result = null;
        if (StringUtils.isNotEmpty((CharSequence)respValue)) {
            result = String.class == valueClass ? respValue : (Boolean.class == valueClass ? Boolean.valueOf(respValue) : (Integer.class == valueClass ? Integer.valueOf(respValue) : (Long.class == valueClass ? Long.valueOf(respValue) : (TimeSlotDto.class == valueClass ? Util.getTimeSlot(respValue) : JacksonUtil.readValue((String)respValue, valueClass)))));
        }
        return (T)result;
    }

    private static TimeSlotDto getTimeSlot(String timeSlot) {
        TimeSlotDto timeSlotDto = new TimeSlotDto();
        String[] times = timeSlot.split("-");
        if (times.length == 2) {
            timeSlotDto.setStartTime(times[0]);
            timeSlotDto.setEndTime(times[1]);
        }
        return timeSlotDto;
    }

    public static Object convert(Object obj, Class<?> parametrized, Class<?> elementClasses) {
        try {
            return Util.fromJson(objectMapper.writeValueAsString(obj), parametrized, elementClasses);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object fromJson(String json, Class<?> parametrized, Class<?> elementClasses) {
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(parametrized, new Class[]{elementClasses});
        try {
            return objectMapper.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            return new RuntimeException(e);
        }
    }
}

