/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.mojo;

import com.dtyunxi.cube.maven.plugin.scan.util.ConfigUtils;
import com.dtyunxi.util.JacksonUtil;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.springframework.util.ClassUtils;
import org.springframework.util.FileCopyUtils;

public abstract class BaseScanMojo {
    protected final MavenProject mavenProject;
    protected final Log log;
    protected List<String> compileClasspathElements;
    protected String outputDirectory;
    protected String groupId;
    protected String artifactId;
    protected String parentArtifactId;
    protected String version;

    public BaseScanMojo(MavenProject mavenProject, Log log) {
        this.mavenProject = mavenProject;
        this.log = log;
        try {
            this.compileClasspathElements = mavenProject.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException("\u83b7\u53d6CompileClasspathElements\u5f02\u5e38", e);
        }
        this.outputDirectory = mavenProject.getBuild().getOutputDirectory();
        this.groupId = mavenProject.getGroupId();
        this.artifactId = mavenProject.getArtifactId();
        this.parentArtifactId = mavenProject.getParent().getArtifactId();
        this.version = mavenProject.getVersion();
    }

    public List<Class<?>> getModuleClasses() {
        URLClassLoader classLoader = Objects.requireNonNull((URLClassLoader)ClassUtils.getDefaultClassLoader(), "\u7c7b\u52a0\u8f7d\u5668\u4e3a\u7a7a");
        this.compileClasspathElements.forEach(e -> ConfigUtils.addURLToClassLoad(classLoader, e));
        return this.compileClasspathElements.stream().filter(classpath -> new File((String)classpath).isDirectory()).flatMap(classpath -> ConfigUtils.getClasses(new File((String)classpath).getAbsolutePath().length(), new File((String)classpath), classLoader).stream()).collect(Collectors.toList());
    }

    public abstract void execute();

    public void writeFile(Object obj, String filepath) throws IOException {
        File file = new File(this.outputDirectory + File.separator + filepath);
        File parentFile = file.getParentFile();
        if (parentFile.exists() || parentFile.mkdirs()) {
            FileCopyUtils.copy((byte[])Objects.requireNonNull(JacksonUtil.toJson((Object)obj)).getBytes(StandardCharsets.UTF_8), (File)file);
            this.log.info((CharSequence)("\u751f\u6210" + filepath + "\u6587\u4ef6\u6210\u529f"));
        } else {
            this.log.error((CharSequence)("\u521b\u5efa\u76ee\u5f55\u5931\u8d25:" + parentFile.getAbsolutePath()));
        }
    }
}

