/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.mojo;

import com.dtyunxi.cube.maven.plugin.scan.mojo.ApiScanMojo;
import com.dtyunxi.cube.maven.plugin.scan.mojo.BizScanMojo;
import com.dtyunxi.cube.maven.plugin.scan.mojo.ConfScanMojo;
import com.dtyunxi.cube.maven.plugin.scan.mojo.DtoScanMojo;
import com.dtyunxi.cube.maven.plugin.scan.mojo.EoScanMojo;
import com.dtyunxi.cube.maven.plugin.scan.mojo.EventScanMojo;
import com.dtyunxi.cube.maven.plugin.scan.mojo.FlowDocScanMojo;
import com.dtyunxi.cube.maven.plugin.scan.mojo.FlowNodeScanMojo;
import com.dtyunxi.cube.maven.plugin.scan.mojo.ServiceScanMojo;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="bundle-scan", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.COMPILE)
public class BundleScanMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.parent.artifactId}", readonly=true)
    private String parentArtifactId;
    @Parameter(defaultValue="${project}")
    private MavenProject mavenProject;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String artifactId = this.mavenProject.getArtifactId();
        Log log = this.getLog();
        if ((this.parentArtifactId + "api").equals(artifactId)) {
            new ApiScanMojo(this.mavenProject, log).execute();
            new DtoScanMojo(this.mavenProject, log).execute();
        } else if ((this.parentArtifactId + "stdeo").equals(artifactId) || (this.parentArtifactId.replace("-center", "") + "stdeo").equals(artifactId)) {
            new EoScanMojo(this.mavenProject, log).execute();
        } else if ((this.parentArtifactId + "eo").equals(artifactId) || (this.parentArtifactId.replace("-center", "") + "eo").equals(artifactId)) {
            new FlowDocScanMojo(this.mavenProject, log).execute();
            new EoScanMojo(this.mavenProject, log).execute();
        } else if ((this.parentArtifactId + "conf").equals(artifactId)) {
            new ConfScanMojo(this.mavenProject, log).execute();
        } else if (!(this.parentArtifactId + "dao").equals(artifactId)) {
            if ((this.parentArtifactId + "service").equals(artifactId)) {
                new ServiceScanMojo(this.mavenProject, log).execute();
            } else if (!(this.parentArtifactId + "web").equals(artifactId)) {
                if ((this.parentArtifactId + "event").equals(artifactId)) {
                    new EventScanMojo(this.mavenProject, log).execute();
                } else {
                    new BizScanMojo(this.mavenProject, log).execute();
                    new FlowNodeScanMojo(this.mavenProject, log).execute();
                }
            }
        }
    }
}

