/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.CustomListSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.alibaba.fastjson.spi.Module;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.dtyunxi.app.AbstractBoot;
import com.dtyunxi.cube.framework.config.SpringEnhanceConfig;
import com.dtyunxi.cube.framework.interceptor.RestInterceptor;
import com.dtyunxi.cube.framework.rest.ApiExceptionAdvice;
import com.dtyunxi.huieryun.core.support.StringToDateConverter;
import com.dtyunxi.huieryun.core.support.StringToLocalDateConverter;
import com.dtyunxi.huieryun.core.support.StringToLocalDateTimeConverter;
import com.dtyunxi.huieryun.core.support.StringToLocalTimeConverter;
import com.dtyunxi.huieryun.log.LoggerServletFilter;
import com.dtyunxi.util.SpringBeanUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Import(value={SpringEnhanceConfig.class})
public class RestAppConfig
implements WebMvcConfigurer,
ApplicationContextAware {
    private final List<RestInterceptor> interceptors = new ArrayList<RestInterceptor>();
    private static ApplicationContext ctx;
    @Value(value="${cube.response.enable-null-field:true}")
    private Boolean enableNullResponse = true;
    @Value(value="${cube.json.date-format:yyyy-MM-dd HH:mm:ss}")
    private String jsonDateFormat;
    @Value(value="${cube.json.time-zone:GMT+8}")
    private String jsonTimeZone;

    public void setApplicationContext(ApplicationContext applicationContext) {
        SpringBeanUtil.setSpringAppContext((ApplicationContext)applicationContext);
    }

    @Deprecated
    protected FastJsonHttpMessageConverter customConverters() {
        FastJsonHttpMessageConverter fastJsonMsgConvert = new FastJsonHttpMessageConverter();
        Charset UTF8 = StandardCharsets.UTF_8;
        fastJsonMsgConvert.setSupportedMediaTypes(Arrays.asList(new MediaType("application", "json", UTF8), new MediaType("application", "*+json", UTF8)));
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        if (this.enableNullResponse.booleanValue()) {
            fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteMapNullValue});
        } else {
            fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat});
        }
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.put(Long.class, (ObjectSerializer)ToStringSerializer.instance);
        serializeConfig.put(Long.TYPE, (ObjectSerializer)ToStringSerializer.instance);
        serializeConfig.register(new Module(){

            public ObjectDeserializer createDeserializer(ParserConfig config, Class type) {
                return null;
            }

            public ObjectSerializer createSerializer(SerializeConfig config, Class type) {
                if (List.class.isAssignableFrom(type)) {
                    return CustomListSerializer.instance;
                }
                return null;
            }
        });
        fastJsonConfig.setSerializeConfig(serializeConfig);
        ParserConfig parserConfig = new ParserConfig();
        fastJsonConfig.setParserConfig(parserConfig);
        fastJsonConfig.setDateFormat(this.jsonDateFormat);
        fastJsonMsgConvert.setFastJsonConfig(fastJsonConfig);
        return fastJsonMsgConvert;
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add(0, (HttpMessageConverter<?>)this.customConverters());
    }

    public void configurePathMatch(PathMatchConfigurer matcher) {
        matcher.setUseRegisteredSuffixPatternMatch(Boolean.valueOf(true));
    }

    public void addInterceptors(InterceptorRegistry registry) {
        this.interceptors.forEach(item -> {
            InterceptorRegistration res = registry.addInterceptor((HandlerInterceptor)item);
            if (item.includePath().length > 0) {
                res.addPathPatterns(item.includePath());
            }
            if (item.excludePath().length > 0) {
                res.excludePathPatterns(item.excludePath());
            }
        });
    }

    public void addInterceptor(RestInterceptor ... item) {
        if (item != null) {
            this.interceptors.addAll(Arrays.asList(item));
        }
    }

    protected static void runApp(Class<?> app, String[] args) throws Exception {
        ctx = new AbstractBoot((Class)app, args){

            @Override
            public void execute() throws Exception {
                LoggerServletFilter.initLogger();
            }
        }.run();
    }

    public static ApplicationContext getCtx() {
        return ctx;
    }

    @Bean
    @ConditionalOnMissingBean(name={"loggerServletFilter"})
    public LoggerServletFilter loggerServletFilter() {
        return new LoggerServletFilter();
    }

    @Bean
    @ConditionalOnMissingBean(name={"springBeanUtil"})
    public SpringBeanUtil springBeanUtil() {
        return new SpringBeanUtil();
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedMethods(new String[]{"*"}).allowedOriginPatterns(new String[]{"*"}).allowCredentials(true).maxAge(Long.MAX_VALUE);
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new StringToLocalDateTimeConverter());
        registry.addConverter((Converter)new StringToLocalDateConverter());
        registry.addConverter((Converter)new StringToLocalTimeConverter());
        registry.addConverter((Converter)new StringToDateConverter());
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiExceptionAdvice apiExceptionAdvice() {
        return new ApiExceptionAdvice();
    }
}

