/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.yira.support;

import com.dtyunxi.cube.framework.yira.support.IXmetaApiToEndPointProvider;
import com.dtyunxi.cube.framework.yira.support.XmetaApiEnhanceProperties;
import com.dtyunxi.cube.framework.yira.support.XmetaApiEnhancePropertiesResoler;
import java.io.IOException;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnProperty(name={"cube.xmeta.enhance.enabled"}, havingValue="true")
@Component(value="xmetaApiToEndPointProvider")
public class XmetaApiToEndPointProviderImpl
implements IXmetaApiToEndPointProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(XmetaApiToEndPointProviderImpl.class);
    private Environment environment;
    private static ClassPool classPool = ClassPool.getDefault();
    protected ClassLoader classLoader;
    private XmetaApiEnhanceProperties enhanceProperties;
    private XmetaApiEnhancePropertiesResoler xmetaApiEnhancePropertiesResoler;

    public void createEndPointProvider(Class xMetaApiClass, Class<?> xMetaApiImplClass, BeanDefinitionRegistry registry) {
        CtClass parentCtClass;
        LOG.info("create EndPoint Provider,ApiClass={},ImplClass={}", (Object)xMetaApiClass.getName(), (Object)xMetaApiImplClass.getName());
        String targetBeanName = this.getTargetBeanName(xMetaApiImplClass);
        targetBeanName = targetBeanName.contains("ApiImpl") ? targetBeanName.replace("ApiImpl", "Rest") : (targetBeanName.contains("Api") ? targetBeanName.replace("Api", "Rest") : targetBeanName + "Rest");
        String apiClassName = xMetaApiClass.getName();
        String apiImplClassName = xMetaApiImplClass.getName();
        if (registry.containsBeanDefinition(targetBeanName)) {
            LOG.error("BeanDefinition with the same beanName already existed, please check your config!  beanName: {}, apiClass:{}, targetClass: {}", new Object[]{targetBeanName, apiClassName, apiImplClassName});
            return;
        }
        String packageName = xMetaApiClass.getPackage().getName().replace(".query", "").replace("api", "rest");
        ConfigurableBeanFactory beanFactory = registry instanceof ConfigurableBeanFactory ? (ConfigurableBeanFactory)registry : null;
        try {
            parentCtClass = classPool.get(xMetaApiImplClass.getName());
        }
        catch (NotFoundException e) {
            LOG.error("\u7c7b\u67e5\u627e\u5f02\u5e38\uff01\u7c7b\u540d\uff1a{}", (Object)xMetaApiImplClass.getName());
            return;
        }
        CtClass endPointProviderClass = classPool.makeClass(packageName + "." + targetBeanName, parentCtClass);
        ClassFile endPointProviderFile = endPointProviderClass.getClassFile();
        ConstPool constpool = endPointProviderFile.getConstPool();
        AnnotationsAttribute classAttr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
        this.createAnnotations(targetBeanName, xMetaApiClass, beanFactory, constpool, classAttr);
        endPointProviderFile.addAttribute((AttributeInfo)classAttr);
        try {
            Class targetClazz;
            if (this.enhanceProperties != null && this.enhanceProperties.isWriteClassFile()) {
                endPointProviderClass.writeFile();
            }
            if ((targetClazz = endPointProviderClass.toClass()) == null) {
                return;
            }
            AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition((Class)targetClazz).getBeanDefinition();
            registry.registerBeanDefinition(targetBeanName, (BeanDefinition)beanDefinition);
            LOG.info("register Rest provider bean: {}, apiClass:{}, targetClass: {}", new Object[]{targetBeanName, apiClassName, apiImplClassName});
        }
        catch (IOException | CannotCompileException | NotFoundException e) {
            String providerClassName = endPointProviderClass.getName();
            LOG.error("create Rest EndPoint Provider:[{}] failed", (Object)providerClassName, (Object)e);
            throw new RuntimeException("create Rest EndPoint Provider:" + providerClassName + " failed.", e);
        }
    }

    private void createAnnotations(String targetBeanName, Class xMetaApiClass, ConfigurableBeanFactory beanFactory, ConstPool constpool, AnnotationsAttribute classAttr) {
        Annotation controller = new Annotation(RestController.class.getName(), constpool);
        controller.addMemberValue("value", (MemberValue)new StringMemberValue(targetBeanName, constpool));
        classAttr.addAnnotation(controller);
        Annotation requestMapping = new Annotation(RequestMapping.class.getName(), constpool);
        ArrayMemberValue memberValue = new ArrayMemberValue(constpool);
        String path = this.xmetaApiEnhancePropertiesResoler.getRestControllerPath(beanFactory, xMetaApiClass);
        memberValue.setValue((MemberValue[])new StringMemberValue[]{new StringMemberValue(path, constpool)});
        requestMapping.addMemberValue("path", (MemberValue)memberValue);
        classAttr.addAnnotation(requestMapping);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setXmetaApiEnhanceProperties(XmetaApiEnhanceProperties enhanceProperties) {
        this.enhanceProperties = enhanceProperties;
    }

    public void setXmetaApiEnhancePropertiesResoler(XmetaApiEnhancePropertiesResoler xmetaApiEnhancePropertiesResoler) {
        this.xmetaApiEnhancePropertiesResoler = xmetaApiEnhancePropertiesResoler;
    }

    public boolean checkEnable() {
        return this.enhanceProperties != null && this.enhanceProperties.isRestController();
    }

    static {
        ClassClassPath path = new ClassClassPath(XmetaApiToEndPointProviderImpl.class);
        classPool.insertClassPath((ClassPath)path);
    }
}

