/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.meta.support;

import com.dtyunxi.yundt.cube.meta.support.DataScriptProcessor;
import com.dtyunxi.yundt.cube.meta.support.FiltUtil;
import com.dtyunxi.yundt.cube.meta.support.ScriptUtil;
import com.dtyunxi.yundt.cube.meta.support.db.DbConn;
import com.dtyunxi.yundt.cube.meta.support.db.DbUtil;
import com.dtyunxi.yundt.cube.meta.support.db.IDatabase;
import com.dtyunxi.yundt.cube.meta.support.db.TableDao;
import com.dtyunxi.yundt.cube.meta.vo2.TableGroupVo;
import com.dtyunxi.yundt.cube.meta.vo2.TableVo;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ScriptGenerator {
    public String insertSql = "";

    private TableVo getTableVo(String tableName) throws Exception {
        Connection conn = DbConn.getConnection();
        IDatabase database = DbConn.getDatabase();
        TableDao tableDao = new TableDao();
        return tableDao.getTable(conn, database, tableName);
    }

    private File prepareOutputDir(String outputDir) {
        File fileOutputDir = new File(outputDir);
        if (!fileOutputDir.exists()) {
            fileOutputDir.mkdirs();
        } else {
            FiltUtil.deleteFile(fileOutputDir, false);
        }
        return fileOutputDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean geneInsertScript(TableGroupVo[] aryTableGroup, String scriptDelimiter, String outputDir) throws Exception {
        TableVo tableVo = null;
        String whereCond = null;
        this.prepareOutputDir(outputDir);
        for (TableGroupVo tableGroup : aryTableGroup) {
            tableVo = this.getTableVo(tableGroup.name);
            String outputFile = outputDir + File.separator + tableGroup.name + ".sql";
            FileWriter fw = new FileWriter(outputFile, true);
            PrintWriter pt = new PrintWriter(fw);
            boolean needGroup = tableGroup.listTableGroup.size() != 0;
            String pkColumn = tableVo.getPrimaryKeys()[0];
            if (tableGroup.referenceKey != null) {
                pkColumn = tableGroup.referenceKey;
            }
            System.out.println("Exporting data from table " + tableGroup.name);
            try {
                if (needGroup) {
                    for (String primaryKey : tableGroup.listKey) {
                        whereCond = ScriptUtil.getWhereCond(pkColumn, primaryKey, tableGroup.fixedwhere);
                        DataScriptProcessor processor = this.geneTableScript(tableVo, tableGroup, whereCond, scriptDelimiter, pt);
                        for (TableGroupVo subTableGroup : tableGroup.listTableGroup) {
                            if (subTableGroup.referenceKey != null) {
                                subTableGroup.listKey = processor.getValues(subTableGroup.referenceKey);
                            } else {
                                subTableGroup.listKey = new ArrayList<String>();
                                subTableGroup.listKey.add(primaryKey);
                            }
                            this.procTableGroup(subTableGroup, scriptDelimiter, pt);
                        }
                        pt.write("\n");
                        pt.flush();
                    }
                    continue;
                }
                whereCond = ScriptUtil.getWhereCond(pkColumn, tableGroup.listKey, tableGroup.fixedwhere);
                this.geneTableScript(tableVo, tableGroup, whereCond, scriptDelimiter, pt);
            }
            finally {
                if (pt != null) {
                    pt.close();
                    fw.close();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataScriptProcessor geneTableScript(TableVo tableVo, TableGroupVo tableGroup, String whereCondition, String dbDelimiter, PrintWriter pt) throws Exception {
        ResultSet resultSet;
        Statement stmt;
        DataScriptProcessor dataScriptProcessor;
        block5: {
            dataScriptProcessor = new DataScriptProcessor(tableVo, tableGroup);
            stmt = null;
            resultSet = null;
            try {
                String querySql = TableDao.getTableDataQuery(tableVo, null, whereCondition);
                if (tableGroup.foreignKey != null) {
                    querySql = querySql + " order by " + tableGroup.foreignKey;
                }
                System.out.println("Query : " + querySql);
                stmt = DbConn.getConnection().createStatement();
                resultSet = stmt.executeQuery(querySql);
                Object data = dataScriptProcessor.processResultSet(resultSet);
                if (data == null) break block5;
                List<String> listSql = dataScriptProcessor.getInsertSql();
                StringBuilder sb = new StringBuilder();
                if (listSql.size() > 0) {
                    for (String sql : listSql) {
                        System.out.println(sql + dbDelimiter);
                        pt.write(sql + dbDelimiter + "\n");
                        sb.append(sql + dbDelimiter + "\n");
                    }
                    this.insertSql = this.insertSql + sb;
                }
            }
            catch (Throwable throwable) {
                DbUtil.closeQuitely(resultSet);
                DbUtil.closeQuitely(stmt);
                throw throwable;
            }
        }
        DbUtil.closeQuitely(resultSet);
        DbUtil.closeQuitely(stmt);
        return dataScriptProcessor;
    }

    private void procTableGroup(TableGroupVo tableGroup, String dbDelimiter, PrintWriter pw) throws Exception {
        TableVo tableVO = this.getTableVo(tableGroup.name);
        String pkColumn = tableGroup.foreignKey;
        String whereCond = ScriptUtil.getWhereCond(pkColumn, tableGroup.listKey, tableGroup.fixedwhere);
        DataScriptProcessor processor = this.geneTableScript(tableVO, tableGroup, whereCond, dbDelimiter, pw);
        for (TableGroupVo subTableGroup : tableGroup.listTableGroup) {
            subTableGroup.listKey = subTableGroup.referenceKey != null ? processor.getValues(subTableGroup.referenceKey) : processor.getPrimaryValues();
            this.procTableGroup(subTableGroup, dbDelimiter, pw);
        }
    }
}

