/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils;

import com.dtyunxi.cube.utils.net.ParamsUtils;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureUtil {
    private static final Logger Log = LoggerFactory.getLogger(SignatureUtil.class);

    public static String sign(Map<String, String> params) {
        return DigestUtils.sha256Hex((String)ParamsUtils.sortQueryStr(params));
    }

    public static boolean isValid(Map<String, String> params, String signedString) {
        return SignatureUtil.sign(params).equals(signedString);
    }

    public static String sign(Map<String, String> params, String secretKey) {
        HmacUtils hm1 = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, secretKey);
        return hm1.hmacHex(ParamsUtils.sortQueryStr(params));
    }

    public static String sign(String params, String secretKey) {
        HmacUtils hm1 = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, secretKey);
        return hm1.hmacHex(ParamsUtils.sortQueryStr(params));
    }

    public static boolean isValid(Map<String, String> params, String signedString, String secretKey) {
        return SignatureUtil.sign(params, secretKey).equals(signedString);
    }

    public static boolean isValid(String params, String signedString, String secretKey) {
        return SignatureUtil.sign(params, secretKey).equals(signedString);
    }
}

