/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.codec.Coder;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtil {
    public static final String TOKEN_USER_ID = "id";
    public static final String TOKEN_USER_NAME = "loginName";
    public static final String TOKEN_INSTANCE_ID = "instanceId";
    public static final String TOKEN_TENANT_ID = "tenantId";
    public static final String TOKEN_ROLE_SET = "roleSet";
    public static final String HTTP_HEADER_TOKEN_KEY = "Access-Token";
    private static final Logger Log = LoggerFactory.getLogger(TokenUtil.class);
    private final Map<String, ?> tokenData;

    private TokenUtil() {
        this.tokenData = new HashMap();
    }

    public TokenUtil(String token, String secretKey) {
        this.tokenData = TokenUtil.parse(token, secretKey);
    }

    public static String generate(String secretKey, Date expiryDate, Map<String, Object> payload) {
        return TokenUtil.generate(Jwts.builder().setClaims(payload), secretKey, expiryDate);
    }

    public static String generate(String secretKey, int expirySeconds, Map<String, Object> payload) {
        return TokenUtil.generate(secretKey, DateUtil.addSeconds(new Date(), expirySeconds), payload);
    }

    public static String generate(String secretKey, Date expiryDate) {
        return TokenUtil.generate(Jwts.builder(), secretKey, expiryDate);
    }

    public static String generate(String secretKey, int expirySeconds) {
        return TokenUtil.generate(Jwts.builder(), secretKey, DateUtil.addSeconds(new Date(), expirySeconds));
    }

    public static Map<String, Object> parse(String token, String secretKey) {
        return (Map)Jwts.parser().setSigningKey(TokenUtil.generateKey(secretKey)).parseClaimsJws(token).getBody();
    }

    public static Map<String, Object> parse(String token) {
        token = token.substring(token.indexOf(".") + 1, token.lastIndexOf("."));
        return JSON.parseObject((String)Coder.base64DecodeToStr(token));
    }

    public static boolean isValid(String token, String secretKey) {
        try {
            TokenUtil.parse(token, secretKey);
            return true;
        }
        catch (Exception e) {
            Log.error("Invalid token : {}", (Object)token);
            Log.debug("Invalid token :" + e);
            return false;
        }
    }

    private static Key generateKey(String secretKey) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        SecretKeySpec signingKey = new SecretKeySpec(DigestUtils.md5Hex((String)secretKey).getBytes(), signatureAlgorithm.getJcaName());
        return signingKey;
    }

    private static String generate(JwtBuilder jwtBuilder, String secretKey, Date expiryDate) {
        return jwtBuilder.setId(UUID.randomUUID().toString()).setNotBefore(new Date()).setExpiration(expiryDate).signWith(TokenUtil.generateKey(secretKey)).compact();
    }

    public Long getUserId() {
        return Long.parseLong(this.tokenData.get(TOKEN_USER_ID).toString());
    }

    public Long getInstanceId() {
        return Long.parseLong(this.tokenData.get(TOKEN_INSTANCE_ID).toString());
    }

    public String getUserName() {
        return this.tokenData.get(TOKEN_USER_NAME).toString();
    }

    public Long getTenantId() {
        return Long.parseLong(this.tokenData.get(TOKEN_TENANT_ID).toString());
    }
}

