/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.threads.pattens;

import com.dtyunxi.cube.utils.threads.CommonThreadPool;
import com.dtyunxi.cube.utils.threads.pattens.ConsumerThread;
import com.dtyunxi.cube.utils.threads.pattens.ConsumerWorker;
import com.dtyunxi.cube.utils.threads.pattens.ProducerThread;
import com.dtyunxi.cube.utils.threads.pattens.ProducerWorker;
import com.dtyunxi.cube.utils.threads.pattens.ProductStore;

public class ProdConsuPatten<T> {
    ConsumerThread<T> consumer;
    ProducerThread<T> producer;
    ProductStore<T> store;
    CommonThreadPool pool;
    boolean started = false;

    public ProdConsuPatten(CommonThreadPool pool, ProductStore<T> store, ConsumerWorker<T> consu, ProducerWorker prod) {
        this.producer = new ProducerThread<T>(store, prod);
        this.consumer = new ConsumerThread<T>(store, consu);
        this.store = store;
        this.pool = pool;
    }

    public synchronized void start() {
        if (!this.started) {
            this.pool.execute(this.consumer);
            this.started = true;
        }
    }

    public synchronized void stop() {
        if (this.started) {
            this.producer.setRunning(false);
            this.consumer.setRunning(false);
            this.started = false;
        }
    }

    public void put(T prod) throws InterruptedException {
        this.store.push(prod);
    }
}

