/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.excel;

import com.dtyunxi.cube.excel.annotation.ExcelColumn;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    private static final String XLS = "xls";
    private static final String XLSX = "xlsx";
    private static Integer rowIndex;
    private static String columnName;

    public static <T> List<T> readExcel(String fileName, Class<T> dest, int startRow) {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new RuntimeException(fileName + "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return ExcelUtils.readExcel(file, dest, startRow);
    }

    public static <T> List<T> readExcel(File file, Class<T> dest, int startRow) {
        if (!file.exists()) {
            throw new RuntimeException(file.getAbsolutePath() + "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        FileInputStream fis = null;
        try {
            HSSFWorkbook workbook;
            fis = new FileInputStream(file);
            if (file.getName().endsWith(XLS)) {
                workbook = new HSSFWorkbook((InputStream)fis);
            } else if (file.getName().endsWith(XLSX)) {
                workbook = new XSSFWorkbook((InputStream)fis);
            } else {
                throw new RuntimeException("\u672a\u652f\u6301\u7684excel\u6587\u4ef6");
            }
            List<T> list = ExcelUtils.readExcel((Workbook)workbook, dest, startRow);
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static <T> List<T> readExcel(InputStream in, Class<T> dest, int startRow, String filExtension) {
        if (in == null) {
            throw new NullPointerException("\u8f93\u5165\u6d41\u4e3a\u7a7a");
        }
        if (filExtension == null || filExtension.trim().length() == 0) {
            throw new RuntimeException("\u672a\u77e5\u7684\u6587\u4ef6\u540e\u7f00,xls or xlsx");
        }
        try {
            HSSFWorkbook workbook;
            if (filExtension.equalsIgnoreCase(XLS)) {
                workbook = new HSSFWorkbook(in);
            } else if (filExtension.equalsIgnoreCase(XLSX)) {
                workbook = new XSSFWorkbook(in);
            } else {
                throw new RuntimeException("\u672a\u652f\u6301\u7684excel\u6587\u4ef6");
            }
            return ExcelUtils.readExcel((Workbook)workbook, dest, startRow);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> readExcel(OutputStream out, Class<T> dest, int startRow, String filExtension) {
        if (out == null) {
            throw new NullPointerException("\u8f93\u51fa\u6d41\u4e3a\u7a7a");
        }
        if (filExtension == null || filExtension.trim().length() == 0) {
            throw new RuntimeException("\u672a\u77e5\u7684\u6587\u4ef6\u540e\u7f00,xls or xlsx");
        }
        ByteArrayOutputStream baos = (ByteArrayOutputStream)out;
        ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
        return ExcelUtils.readExcel(in, dest, startRow, filExtension);
    }

    private static <T> List<T> readExcel(Workbook workbook, Class<T> dest, int startRow) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            int sheetCount = workbook.getNumberOfSheets();
            for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
                Sheet sheet = workbook.getSheetAt(sheetIndex);
                if (sheet == null) continue;
                int lastRowNum = sheet.getLastRowNum();
                if (startRow > 0) {
                    // empty if block
                }
                for (int rowNum = --startRow; rowNum <= lastRowNum; ++rowNum) {
                    Field[] fields;
                    Row row = sheet.getRow(rowNum);
                    if (row == null) continue;
                    rowIndex = rowNum;
                    T obj = dest.newInstance();
                    for (Field field : fields = obj.getClass().getDeclaredFields()) {
                        ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
                        if (excelColumn == null) continue;
                        columnName = excelColumn.value();
                        Cell cell = row.getCell(ExcelUtils.parseCellIndex(excelColumn.value()));
                        if (cell == null) continue;
                        cell.setCellType(1);
                        String strValue = cell.getStringCellValue();
                        if (strValue == null || strValue.trim().length() == 0) continue;
                        Object fieldValue = ExcelUtils.parseValue(field, strValue, excelColumn);
                        field.setAccessible(true);
                        field.set(obj, fieldValue);
                    }
                    list.add(obj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (workbook != null) {
                    workbook.close();
                }
            }
            catch (Exception exception) {}
        }
        return list;
    }

    private static int parseCellIndex(String columnName) {
        if (columnName == null || columnName.trim().length() == 0) {
            throw new RuntimeException("ExcelColumn\u6ce8\u89e3name\u5fc5\u586b");
        }
        byte[] bytes = columnName.toUpperCase().getBytes();
        int count = 0;
        for (byte b : bytes) {
            count += b;
        }
        return count - 65;
    }

    private static Object parseValue(Field field, String value, ExcelColumn excelColumn) {
        value = value.replaceAll("\u3000", "");
        Class<?> fieldType = field.getType();
        if (Boolean.class.equals(fieldType) || Boolean.TYPE.equals(fieldType)) {
            return ExcelUtils.parseBoolean(value);
        }
        if (String.class.equals(fieldType)) {
            return value;
        }
        if (Short.class.equals(fieldType) || Short.TYPE.equals(fieldType)) {
            return ExcelUtils.parseShort(value);
        }
        if (Integer.class.equals(fieldType) || Integer.TYPE.equals(fieldType)) {
            return ExcelUtils.parseInt(value);
        }
        if (Long.class.equals(fieldType) || Long.TYPE.equals(fieldType)) {
            return ExcelUtils.parseLong(value);
        }
        if (Float.class.equals(fieldType) || Float.TYPE.equals(fieldType)) {
            return ExcelUtils.parseFloat(value);
        }
        if (Double.class.equals(fieldType) || Double.TYPE.equals(fieldType)) {
            return ExcelUtils.parseDouble(value);
        }
        if (Date.class.equals(fieldType)) {
            return ExcelUtils.parseDate(value, excelColumn.dateFormat());
        }
        throw new RuntimeException("\u672a\u77e5\u7684\u8f6c\u6362\u7c7b\u578b");
    }

    private static Boolean parseBoolean(String value) {
        if (Boolean.TRUE.toString().equalsIgnoreCase(value) || "\u662f".equals(value)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(value) || "\u5426".equals(value)) {
            return Boolean.FALSE;
        }
        throw new RuntimeException(columnName + "\u5217" + rowIndex + "\u884c\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u8f6cBoolean\u51fa\u9519\uff0c\u5165\u53c2=" + value);
    }

    private static Short parseShort(String value) {
        try {
            return Short.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(columnName + "\u5217" + rowIndex + "\u884c\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u8f6cShort\u51fa\u9519\uff0c\u5165\u53c2=" + value, e);
        }
    }

    private static Integer parseInt(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(columnName + "\u5217" + rowIndex + "\u884c\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u8f6cInteger\u51fa\u9519\uff0c\u5165\u53c2=" + value, e);
        }
    }

    private static Long parseLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(columnName + "\u5217" + rowIndex + "\u884c\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u8f6cLong\u51fa\u9519\uff0c\u5165\u53c2=" + value, e);
        }
    }

    private static Float parseFloat(String value) {
        try {
            return Float.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(columnName + "\u5217" + rowIndex + "\u884c\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u8f6cFloat\u51fa\u9519\uff0c\u5165\u53c2=" + value, e);
        }
    }

    private static Double parseDouble(String value) {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(columnName + "\u5217" + rowIndex + "\u884c\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u8f6cDouble\u51fa\u9519\uff0c\u5165\u53c2=" + value, e);
        }
    }

    private static Date parseDate(String value, String datePattern) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
            return dateFormat.parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException(columnName + "\u5217" + rowIndex + "\u884c\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u8f6cDate\u51fa\u9519\uff0c\u5165\u53c2=" + value, e);
        }
    }
}

