/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.cache.api;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.util.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public interface IBaseOperations {
    public static final int CONNECTION_TIMEOUT = 3000;

    public String getDefaultGroup();

    default public String combineKey(String key) {
        return this.getDefaultGroup() + ":" + key;
    }

    default public String combineKey(String group, String key) {
        if (StrUtil.isNotBlank((CharSequence)group)) {
            return group + ":" + key;
        }
        return key;
    }

    default public List<String> combineKeys(List<String> keys) {
        return this.combineKeys(this.getDefaultGroup(), keys);
    }

    default public List<String> combineKeys(String group, List<String> keys) {
        ArrayList<String> templ = new ArrayList<String>(keys.size());
        for (String key : keys) {
            templ.add(this.combineKey(group, key));
        }
        return templ;
    }

    default public String[] combineKeys(String[] keys) {
        return this.combineKeys(this.getDefaultGroup(), keys);
    }

    default public String[] combineKeys(String group, String[] keys) {
        String[] templ = new String[keys.length];
        for (int keyIdx = 0; keyIdx < templ.length; ++keyIdx) {
            templ[keyIdx] = this.combineKey(group, keys[keyIdx]);
        }
        return templ;
    }

    default public Map<String, String> getCombineDataMap(String group, Map<String, String> dataMap) {
        if (CollectionUtils.isEmpty(dataMap)) {
            return new ConcurrentHashMap<String, String>(0);
        }
        HashMap<String, String> combineDataMap = new HashMap<String, String>(dataMap.size());
        dataMap.entrySet().parallelStream().forEach(entry -> {
            String combineKey = this.combineKey(group, (String)entry.getKey());
            combineDataMap.put(combineKey, (String)entry.getValue());
        });
        return combineDataMap;
    }

    default public <T> String[] listToArray(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new String[0];
        }
        List stringList = list.parallelStream().map(obj -> JacksonUtil.toJson((Object)obj)).collect(Collectors.toList());
        return (String[])stringList.stream().toArray(String[]::new);
    }

    default public <T> List<T> stringToObjects(List<String> list, Class<T> clazz) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.parallelStream().map(str -> {
            if (clazz.isPrimitive() || clazz.equals(String.class)) {
                return clazz.cast(str);
            }
            return JacksonUtil.readValue((String)str, (Class)clazz);
        }).collect(Collectors.toList());
    }

    default public <T> List<T> stringToObjects(List<String> list, TypeReference<T> clazz) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.parallelStream().map(str -> JacksonUtil.readValue((String)str, (TypeReference)clazz)).collect(Collectors.toList());
    }

    default public Set<String> objToString(Set<Object> values) {
        Set result = null;
        if (!CollectionUtils.isEmpty(values)) {
            result = values.stream().map(v -> v.toString()).collect(Collectors.toSet());
        }
        return result;
    }

    default public List<String> objToString(List<Object> values) {
        if (!CollectionUtils.isEmpty(values)) {
            return values.stream().map(v -> String.valueOf(v)).collect(Collectors.toList());
        }
        return null;
    }

    default public <T> Map<String, List<T>> listToMap(String[] fields, List<String> content, TypeReference<List<T>> typeReference) {
        HashMap<String, List<T>> stringTHashMap = new HashMap<String, List<T>>();
        if (null != fields && fields.length > 0 && !CollectionUtils.isEmpty(content)) {
            for (int i = 0; i < fields.length; ++i) {
                stringTHashMap.put(fields[i], StrUtil.isNotEmpty((CharSequence)content.get(i)) ? (List)JacksonUtil.readValue((String)content.get(i), typeReference) : null);
            }
        }
        return stringTHashMap;
    }

    default public <T> Map<String, T> stringToMap(String[] fields, List<String> content, Class<T> clazz) {
        HashMap<String, Object> stringTHashMap = new HashMap<String, Object>();
        if (null != fields && fields.length > 0 && !CollectionUtils.isEmpty(content)) {
            for (int i = 0; i < fields.length; ++i) {
                stringTHashMap.put(fields[i], StrUtil.isNotEmpty((CharSequence)content.get(i)) ? JacksonUtil.readValue((String)content.get(i), clazz) : null);
            }
        }
        return stringTHashMap;
    }

    default public Map<String, String> objToStringMap(Map<Object, Object> map) {
        HashMap<String, String> result = null;
        if (!CollectionUtils.isEmpty(map)) {
            result = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                result.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return result;
    }

    default public <T> T jsonToObj(String json, Class<T> clazz) {
        Object value = null;
        if (StrUtil.isNotEmpty((CharSequence)json)) {
            value = JacksonUtil.readValue((String)json, clazz);
        }
        return (T)value;
    }

    default public <T> T stringToObject(String json, TypeReference<T> clz) {
        Object value = null;
        if (StrUtil.isNotEmpty((CharSequence)json)) {
            value = JacksonUtil.readValue((String)json, clz);
        }
        return (T)value;
    }
}

