/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.comm.util;

import com.dtyunxi.huieryun.comm.vo.wx.AccessToken;
import com.dtyunxi.huieryun.comm.vo.wx.Authorization;
import com.dtyunxi.huieryun.comm.vo.wx.JsapiTicket;
import com.dtyunxi.huieryun.comm.vo.wx.UserInfo;
import com.dtyunxi.util.HttpUtil;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.util.WeiXinApi;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeixinUtil {
    private static final Logger logger = LoggerFactory.getLogger(WeixinUtil.class);
    private static final String WX_ACCESS_TOKEN = "accessToken";
    private static final String WX_JSAPI_TICKET = "jsApiTicket";

    public static AccessToken getAccessToken(String appId, String appsecret) {
        String url = WeiXinApi.getTokenUrl((String)appId, (String)appsecret);
        String json = HttpUtil.sendGet((String)url);
        AccessToken accessToken = null;
        try {
            accessToken = (AccessToken)JacksonUtil.readValue((String)json, AccessToken.class);
        }
        catch (Exception e) {
            logger.info("AccessToken-json\u8f6c\u6362\u9519\u8bef", (Throwable)e);
        }
        return accessToken;
    }

    public static JsapiTicket getJsapiTicket(String token) {
        String url = WeiXinApi.getJsApiTicketUrl((String)token);
        String json = HttpUtil.sendGet((String)url);
        JsapiTicket jsapiTicket = null;
        try {
            jsapiTicket = (JsapiTicket)JacksonUtil.readValue((String)json, JsapiTicket.class);
        }
        catch (Exception e) {
            logger.info("JsapiTicket-json\u8f6c\u6362\u9519\u8bef", (Throwable)e);
        }
        return jsapiTicket;
    }

    public static Authorization getAuthorization(String appId, String appsecret, String code) {
        String json = HttpUtil.sendGet((String)WeiXinApi.getOAuthTokenUrl((String)appId, (String)appsecret, (String)code));
        logger.info(json);
        Authorization authorization = null;
        try {
            authorization = (Authorization)JacksonUtil.readValue((String)json, Authorization.class);
        }
        catch (Exception e) {
            logger.info("Authorization-json\u8f6c\u6362\u9519\u8bef", (Throwable)e);
        }
        return authorization;
    }

    public static UserInfo getUserInfo(String openid, String token) {
        String ticketJson = HttpUtil.sendGet((String)WeiXinApi.getUserinfoUrl((String)token, (String)openid));
        logger.info(ticketJson);
        UserInfo userInfo = (UserInfo)JacksonUtil.readValue((String)ticketJson, UserInfo.class);
        return userInfo;
    }

    public static Map<String, String> sign(String jsapi_ticket, String url, String appId) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String nonceStr = WeixinUtil.create_nonce_str();
        String timestamp = WeixinUtil.create_timestamp();
        String signature = "";
        String plain = "jsapi_ticket=" + jsapi_ticket + "&noncestr=" + nonceStr + "&timestamp=" + timestamp + "&url=" + url;
        System.out.println(plain);
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(plain.getBytes("UTF-8"));
            signature = WeixinUtil.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ret.put("url", url);
        ret.put("jsapi_ticket", jsapi_ticket);
        ret.put("nonceStr", nonceStr);
        ret.put("timestamp", timestamp);
        ret.put("signature", signature);
        ret.put("appId", appId);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getTemporaryMedia(String token, String mediaId) {
        String url = WeiXinApi.getTemporaryMediaUrl((String)token, (String)mediaId);
        InputStream inputStream = null;
        ByteArrayOutputStream bos = null;
        try {
            int n;
            URL s = new URL(url);
            URLConnection connection = s.openConnection();
            inputStream = connection.getInputStream();
            bos = new ByteArrayOutputStream(1024);
            byte[] b = new byte[1024];
            while ((n = inputStream.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u4e34\u65f6\u7d20\u6750\u65f6\u51fa\u9519", (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static String create_nonce_str() {
        return UUID.randomUUID().toString();
    }

    private static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    public static String getAccessTokenKey(String appId) {
        return WX_ACCESS_TOKEN + appId;
    }

    public static String getjsApiTicketKey(String appId) {
        return WX_JSAPI_TICKET + appId;
    }
}

