/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.comm.vo.dingtalk;

import com.dtyunxi.huieryun.comm.vo.dingtalk.AbstMessage;
import com.dtyunxi.huieryun.comm.vo.dingtalk.ActionButtonStyle;
import com.dtyunxi.huieryun.comm.vo.dingtalk.ActionCardAction;
import com.dtyunxi.huieryun.comm.vo.dingtalk.MarkdownMessage;
import com.dtyunxi.util.JacksonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ActionCardMessage
extends AbstMessage {
    public static final int MAX_ACTION_BUTTON_CNT = 5;
    public static final int MIN_ACTION_BUTTON_CNT = 1;
    private String title;
    private String bannerURL;
    private String briefTitle;
    private String briefText;
    private boolean hideAvatar;
    private ActionButtonStyle actionButtonStyle = ActionButtonStyle.VERTICAL;
    private List<ActionCardAction> actions = new ArrayList<ActionCardAction>();

    public boolean isHideAvatar() {
        return this.hideAvatar;
    }

    public void setHideAvatar(boolean hideAvatar) {
        this.hideAvatar = hideAvatar;
    }

    public String getBriefTitle() {
        return this.briefTitle;
    }

    public void setBriefTitle(String briefTitle) {
        this.briefTitle = briefTitle;
    }

    public ActionButtonStyle getActionButtonStyle() {
        return this.actionButtonStyle;
    }

    public void setActionButtonStyle(ActionButtonStyle actionButtonStyle) {
        this.actionButtonStyle = actionButtonStyle;
    }

    public String getBannerURL() {
        return this.bannerURL;
    }

    public void setBannerURL(String bannerURL) {
        this.bannerURL = bannerURL;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBriefText() {
        return this.briefText;
    }

    public void setBriefText(String briefText) {
        this.briefText = briefText;
    }

    public void addAction(ActionCardAction action) {
        if (this.actions.size() >= 5) {
            throw new IllegalArgumentException("number of actions can't more than 5");
        }
        this.actions.add(action);
    }

    public String toString() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("msgtype", "actionCard");
        HashMap<String, Object> actionCardContent = new HashMap<String, Object>();
        actionCardContent.put("title", this.title);
        StringBuffer text = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)this.bannerURL)) {
            text.append(MarkdownMessage.getImageText(this.bannerURL) + "\n");
        }
        if (StringUtils.isNotBlank((CharSequence)this.briefTitle)) {
            text.append(MarkdownMessage.getHeaderText(3, this.briefTitle) + "\n");
        }
        if (StringUtils.isNotBlank((CharSequence)this.briefText)) {
            text.append(this.briefText + "\n");
        }
        actionCardContent.put("text", text.toString());
        if (this.hideAvatar) {
            actionCardContent.put("hideAvatar", "1");
        }
        if (this.actions.size() < 1) {
            throw new IllegalArgumentException("number of actions can't less than 1");
        }
        actionCardContent.put("btns", this.actions);
        if (this.actions.size() == 2 && this.actionButtonStyle == ActionButtonStyle.HORIZONTAL) {
            actionCardContent.put("btnOrientation", "1");
        }
        items.put("actionCard", actionCardContent);
        return JacksonUtil.toJson(items);
    }
}

