/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import com.dtyunxi.util.DateUtil;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiReadExcelUtil {
    private static final Logger logger = LoggerFactory.getLogger(PoiReadExcelUtil.class);
    static LinkedList[] result = null;
    static List<LinkedList[]> contentList = null;
    static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static List<LinkedList[]> readExcelTitle(InputStream inputStream, int startRowTitle) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            if (workbook.getNumberOfSheets() < 1) {
                return contentList;
            }
            contentList = new ArrayList<LinkedList[]>();
            for (int n = 0; n < workbook.getNumberOfSheets(); ++n) {
                int rowTitle;
                Boolean titleFirstBool = true;
                Sheet sheet = workbook.getSheetAt(n);
                int rowNum = sheet.getLastRowNum() + 1;
                int n2 = rowTitle = startRowTitle > 0 ? startRowTitle : 1;
                if (rowNum >= rowTitle) {
                    result = new LinkedList[1];
                    int i = rowTitle - 1;
                    Row row = sheet.getRow(i);
                    PoiReadExcelUtil.result[0] = new LinkedList();
                    if (row != null) {
                        for (int j = 0; j < row.getLastCellNum(); ++j) {
                            Object columnValue;
                            Cell cell = row.getCell(j);
                            Object object = columnValue = cell != null ? PoiReadExcelUtil.getCellValue(cell) : "";
                            if (j == row.getLastCellNum() - 1 && "".equals(columnValue)) continue;
                            result[0].add(columnValue);
                            if (columnValue != null && !"".equals(columnValue)) continue;
                            titleFirstBool = false;
                        }
                    }
                }
                if (!titleFirstBool.booleanValue() || result == null || result[0].size() <= 0) continue;
                contentList.add(result);
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6Excel\u8868\u5934\u6570\u636e\u65f6\u5f02\u5e38,msg:{}", (Object)e.getMessage());
            throw new RuntimeException("\u8bfb\u53d6Excel\u8868\u5934\u6570\u636e\u65f6\u5f02\u5e38", e);
        }
        return contentList;
    }

    public static List<LinkedList[]> readExcelData(InputStream inputStream, int startRowData) {
        return PoiReadExcelUtil.readExcelData(inputStream, startRowData, 0, 0);
    }

    public static List<LinkedList[]> readExcelData(InputStream inputStream, int startRowData, int columnNum, int sheetsNum) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            if (workbook.getNumberOfSheets() < 1) {
                return contentList;
            }
            contentList = new ArrayList<LinkedList[]>();
            int numberOfSheets = workbook.getNumberOfSheets();
            if (sheetsNum > 0) {
                numberOfSheets = sheetsNum;
            }
            for (int n = 0; n < numberOfSheets; ++n) {
                Sheet sheet = workbook.getSheetAt(n);
                int rowNum = sheet.getLastRowNum() + 1;
                if (rowNum >= startRowData) {
                    Object columnValue;
                    rowNum = rowNum - startRowData + 1;
                    int alterStartRowData = startRowData - 1;
                    HashMap temMap = new HashMap();
                    ArrayList<Object> temColumnValues = null;
                    boolean verifyBool = false;
                    for (int i = 0; i < rowNum; ++i) {
                        Row row = sheet.getRow(alterStartRowData + i);
                        if (row == null) continue;
                        if (columnNum < 1) {
                            columnNum = row.getLastCellNum();
                        }
                        temColumnValues = new ArrayList<Object>();
                        for (int j = 0; j < columnNum; ++j) {
                            columnValue = PoiReadExcelUtil.getMergedRegionValue(sheet, row, alterStartRowData + i, j);
                            temColumnValues.add(columnValue != null ? columnValue : "");
                            if (columnValue == null || "".equals(columnValue)) continue;
                            verifyBool = true;
                        }
                        if (!verifyBool) continue;
                        temMap.put(i, temColumnValues);
                        verifyBool = false;
                    }
                    result = new LinkedList[temMap.size()];
                    int index = 0;
                    for (Map.Entry map : temMap.entrySet()) {
                        columnValue = (List)map.getValue();
                        PoiReadExcelUtil.result[index] = new LinkedList();
                        Iterator iterator = columnValue.iterator();
                        while (iterator.hasNext()) {
                            Object obj = iterator.next();
                            result[index].add(obj);
                        }
                        ++index;
                    }
                }
                if (result != null && result.length > 0) {
                    contentList.add(result);
                    columnNum = 0;
                    result = null;
                    continue;
                }
                contentList.add(new LinkedList[0]);
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u8868\u683c\u6570\u636e\u65f6\u5f02\u5e38,msg:{}", (Object)e.getMessage());
            throw new RuntimeException("\u8bfb\u53d6\u8868\u683c\u6570\u636e\u65f6\u5f02\u5e38", e);
        }
        return contentList;
    }

    public static Object getMergedRegionValue(Sheet sheet, Row row, int indexRow, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (indexRow < firstRow || indexRow > lastRow || column < firstColumn || column > lastColumn) continue;
            Row fRow = sheet.getRow(firstRow);
            Cell fCell = fRow.getCell(firstColumn);
            return PoiReadExcelUtil.getCellValue(fCell);
        }
        Cell cell = row.getCell(column);
        return PoiReadExcelUtil.getCellValue(cell);
    }

    private static Object getCellValue(Cell cell) {
        String cellValue;
        block5: {
            try {
                if (cell == null) {
                    return "";
                }
                cellValue = cell.getStringCellValue();
            }
            catch (Exception e) {
                DecimalFormat df;
                if (org.apache.poi.ss.usermodel.DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    cellValue = DateUtil.format(date, "yyyy-MM-dd HH:mm:ss");
                }
                double numericCellValue = cell.getNumericCellValue();
                cellValue = String.valueOf(numericCellValue);
                if (cellValue.indexOf("E") > 0) {
                    df = new DecimalFormat("0");
                    cellValue = df.format(numericCellValue);
                }
                if (!cellValue.endsWith(".0")) break block5;
                df = new DecimalFormat("0");
                cellValue = df.format(numericCellValue);
            }
        }
        return cellValue.trim().replaceAll("\n", "");
    }
}

