/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.springboot.beans;

import java.lang.reflect.Field;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class PlaceHolderBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private Class<?> clazzConsumer = null;
    private Class<?> clazzProvider = null;
    private Class<?> clazzApiProvider = null;
    private Class<?> clazzMetaData = null;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        try {
            this.clazzConsumer = Class.forName("com.taobao.hsf.app.spring.util.HSFSpringConsumerBean");
            this.clazzProvider = Class.forName("com.taobao.hsf.app.spring.util.HSFSpringProviderBean");
            this.clazzApiProvider = Class.forName("com.taobao.hsf.app.api.util.HSFApiProviderBean");
            this.clazzMetaData = Class.forName("com.taobao.hsf.model.metadata.ServiceMetadata");
            this.setGroupAndVersion(beanFactory, this.clazzConsumer, false);
            this.setGroupAndVersion(beanFactory, this.clazzProvider, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setGroupAndVersion(ConfigurableListableBeanFactory beanFactory, Class<?> clazz, boolean isProvider) throws Exception {
        String[] beanNames = beanFactory.getBeanNamesForType(clazz);
        Map map = beanFactory.getBeansOfType(clazz);
        String version = System.getProperty("dtyunxi.service.version");
        String group = System.getProperty("dtyunxi.service.group");
        Object[] args = null;
        Class<?>[] parameterTypes = null;
        if (beanNames != null) {
            for (String beanName : beanNames) {
                Object obj = map.get(beanName);
                clazz.getMethod("setVersion", String.class).invoke(obj, version);
                clazz.getMethod("setGroup", String.class).invoke(obj, group);
                if (isProvider) {
                    Field fieldProviderBean = clazz.getDeclaredField("providerBean");
                    fieldProviderBean.setAccessible(true);
                    Object providerBean = fieldProviderBean.get(obj);
                    this.setUniquName(this.clazzApiProvider, providerBean);
                } else {
                    this.setUniquName(clazz, obj);
                }
                clazz.getMethod("init", parameterTypes).invoke(obj, args);
            }
        }
    }

    private void setUniquName(Class<?> beanClazz, Object obj) throws Exception {
        Field fieldMetaData = beanClazz.getDeclaredField("metadata");
        fieldMetaData.setAccessible(true);
        Object metaData = fieldMetaData.get(obj);
        Object[] args = null;
        Class<?>[] parameterTypes = null;
        this.clazzMetaData.getMethod("initUniqueName", parameterTypes).invoke(metaData, args);
    }
}

