/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;

public class DateConverter
implements Converter<String, Date> {
    private static final String FORMAT_DATE_STR = "yyyy-MM-dd";

    public Date convert(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        try {
            String value = source.trim();
            String sb = "";
            if (value.matches("^\\d{4}/\\d{1,2}$")) {
                sb = "yyyy/MM";
            } else if (value.matches("^\\d{4}/\\d{1,2}/\\d{1,2}$")) {
                sb = "yyyy/MM/dd";
            } else if (value.matches("^\\d{4}/\\d{1,2}/\\d{1,2} {1}\\d{1,2}:\\d{1,2}$")) {
                sb = "yyyy/MM/dd HH:mm";
            } else if (value.matches("^\\d{4}/\\d{1,2}/\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$")) {
                sb = "yyyy/MM/dd HH:mm:ss";
            }
            if (value.matches("^\\d{4}-\\d{1,2}$")) {
                sb = "yyyy-MM";
            } else if (value.matches("^\\d{4}-\\d{1,2}-\\d{1,2}$")) {
                sb = FORMAT_DATE_STR;
            } else if (value.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$")) {
                sb = "yyyy-MM-dd HH:mm";
            } else if (value.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$")) {
                sb = "yyyy-MM-dd HH:mm:ss";
            }
            return new SimpleDateFormat(sb).parse(value);
        }
        catch (Exception value) {
            try {
                long date = Long.parseLong(source.trim());
                if (date > 0L) {
                    return new Date(date);
                }
                return null;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to convert from type java.lang.String to type java.util.Date");
            }
        }
    }

    public static String format(Date date) {
        return DateConverter.format(date, FORMAT_DATE_STR);
    }

    public static String format(Date date, String formater) {
        SimpleDateFormat sdf = new SimpleDateFormat(formater);
        return sdf.format(date);
    }

    public static Date parse(String date) {
        return DateConverter.parse(date, FORMAT_DATE_STR);
    }

    public static Date parse(String date, String formater) {
        SimpleDateFormat sdf = new SimpleDateFormat(formater);
        Date result = null;
        try {
            result = sdf.parse(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

