/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;

public class CustomTenantLineInnerInterceptor
extends TenantLineInnerInterceptor {
    public CustomTenantLineInnerInterceptor() {
    }

    public CustomTenantLineInnerInterceptor(TenantLineHandler tenantLineHandler) {
        super(tenantLineHandler);
    }

    protected Expression builderExpression(Expression currentExpression, Table table) {
        if (null == currentExpression) {
            return null;
        }
        final boolean[] hasTenantIdCondition = new boolean[]{false};
        currentExpression.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

            protected void visitBinaryExpression(BinaryExpression expr) {
                Column column;
                if (expr.getLeftExpression() instanceof Column && (column = (Column)expr.getLeftExpression()).getColumnName().equalsIgnoreCase("tenant_id")) {
                    hasTenantIdCondition[0] = true;
                    return;
                }
                expr.getLeftExpression().accept((ExpressionVisitor)this);
                expr.getRightExpression().accept((ExpressionVisitor)this);
            }
        });
        if (hasTenantIdCondition[0]) {
            return currentExpression;
        }
        return super.builderExpression(currentExpression, table);
    }
}

