/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.das;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.CustomTableInfo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.dtyunxi.annotation.LogicColumn;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.ds.BaseEoUtil;
import com.dtyunxi.huieryun.ds.BaseMapper;
import com.dtyunxi.huieryun.ds.CamelToUnderline;
import com.dtyunxi.huieryun.util.EoUtil;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Id;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComBaseDas<T extends BaseEo, P> {
    private static final Long EMPTY_ID = -9999L;
    private static final Integer EMPTY_CACHE_SECONDS = 60;
    public static Integer DEFAULT_PAGE_NUMBER = 1;
    public static Integer DEFAULT_PAGE_SIZE = 10;
    private static final Set<String> IGNORE_SHARDING_FIELDS = new HashSet<String>(Arrays.asList("dr", "serialVersionUID", "logger", "mapColumns", "mapId", "sqlFilters", "EO_ATTRIBUTE", "TAB_COLUMN", "orderByDesc", "orderBy", "sqlOrderBys"));
    private static final Logger LOGGER = LoggerFactory.getLogger(ComBaseDas.class);
    protected Log ibatisLog = LogFactory.getLog(this.getClass());
    private static final Map<String, Boolean> LOGIC_OR_SHARDING_COLUMN_EOS = new HashMap<String, Boolean>();
    private static final boolean USE_CACHE = Boolean.parseBoolean(System.getProperty("cube.combasedas.usecache", "true"));
    private static final boolean RETHROW_EXCEPTION = Boolean.parseBoolean(System.getProperty("cube.combasedas.rethrow", "false"));
    private static final boolean USE_META = Boolean.parseBoolean(System.getProperty("cube.meta.ext.enabled", "false"));
    private boolean entityUnderControl = false;
    private BaseMapper<T> baseMapper;

    protected abstract ICacheService getCacheService();

    protected abstract Map<String, BaseMapper> getMappers();

    protected abstract String getVersion();

    public List<T> select(T record) {
        try {
            return this.getMapper().findList(record);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5217\u8868\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public List<T> select(T record, Integer currentPage, Integer pageSize) {
        currentPage = null == currentPage ? DEFAULT_PAGE_NUMBER : currentPage;
        pageSize = null == pageSize ? DEFAULT_PAGE_SIZE : pageSize;
        try {
            return this.getMapper().findPageList(record, currentPage, pageSize);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5217\u8868\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public List<T> select(T record, boolean cacheable) {
        if (cacheable) {
            return this.select(record);
        }
        return this.getMapper().findList(record);
    }

    public List<T> selectWithColumn(T record, String ... columnNames) {
        return this.getMapper().findListColumn(record, columnNames);
    }

    public List<T> selectLimitSizeWithColumn(T record, Integer pageNum, Integer pageSize, String ... columnNames) {
        return this.getMapper().findPageListWithColumns(record, pageNum, pageSize, columnNames);
    }

    public PageInfo<T> selectPage(T record, Integer currentPage, Integer pageSize) {
        currentPage = null == currentPage ? DEFAULT_PAGE_NUMBER : currentPage;
        pageSize = null == pageSize ? DEFAULT_PAGE_SIZE : pageSize;
        IPage<T> page = this.getMapper().findPage(record, currentPage, pageSize);
        PageInfo pageInfo = new PageInfo(page.getRecords());
        pageInfo.setPageNum(currentPage.intValue());
        pageInfo.setPageSize(pageSize.intValue());
        pageInfo.setPages((int)page.getPages());
        pageInfo.setTotal(page.getTotal());
        return pageInfo;
    }

    public List<T> selectList(T record) {
        return this.selectList(record, DEFAULT_PAGE_NUMBER, DEFAULT_PAGE_SIZE);
    }

    public List<T> selectList(T record, Integer currentPage, Integer pageSize) {
        return this.selectList(record, currentPage, pageSize, false);
    }

    private List<T> selectList(T record, Integer currentPage, Integer pageSize, boolean selectWithCount) {
        currentPage = null == currentPage ? DEFAULT_PAGE_NUMBER : currentPage;
        pageSize = null == pageSize ? DEFAULT_PAGE_SIZE : pageSize;
        List<T> list = this.getMapper().findPageList(record, currentPage, pageSize);
        return list;
    }

    public PageInfo<T> selectPage(T record, Integer currentPage, Integer pageSize, Boolean cacheable) {
        return this.selectPage(record, currentPage, pageSize);
    }

    public PageInfo<T> selectPage(T record) {
        return this.selectPage(record, DEFAULT_PAGE_NUMBER, DEFAULT_PAGE_SIZE);
    }

    public PageInfo<T> selectPage(T record, Boolean cacheable) {
        if (cacheable != null && cacheable.booleanValue()) {
            return this.selectPage(record, DEFAULT_PAGE_NUMBER, DEFAULT_PAGE_SIZE);
        }
        return this.selectPage(record, DEFAULT_PAGE_NUMBER, DEFAULT_PAGE_SIZE, cacheable);
    }

    public T selectByPrimaryKey(Long key) {
        if (this.isUseCache()) {
            T record = this.getCacheByKey(key);
            if (record != null) {
                return EMPTY_ID.equals(record.getId()) ? null : (T)record;
            }
            record = this.getMapper().findById(key);
            if (record != null) {
                this.addCache(record, key);
            } else {
                this.addEmptyCache(key);
            }
            return record;
        }
        return this.getMapper().findById(key);
    }

    public T selectByLogicKey(P key) {
        try {
            if (this.isUseCache()) {
                T returnRecord = this.getCacheByLogicKey(key);
                if (returnRecord != null) {
                    if (EMPTY_ID.equals(returnRecord.getId())) {
                        return null;
                    }
                    return returnRecord;
                }
                T record = this.setLogicKey(key);
                if (record != null) {
                    returnRecord = this.getMapper().find(record);
                    if (returnRecord != null) {
                        this.addLogicCache(returnRecord, key);
                    } else {
                        this.addLogicEmptyCache(key, EMPTY_CACHE_SECONDS);
                    }
                }
                return returnRecord;
            }
            T record = this.setLogicKey(key);
            if (record != null) {
                record = this.getMapper().find(record);
            }
            return record;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u903b\u8f91\u4e3b\u952e\u67e5\u8be2\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public T selectOne(T record) {
        T returnRecod;
        String shardingProperty = this.getShardingProperties(record.getClass());
        if (StrUtil.isNotBlank((CharSequence)shardingProperty) && this.isOnlyShardingColumnQueryEo(record, shardingProperty).booleanValue()) {
            Set<P> logicKeys = this.getLogicKey(record);
            if (CollectionUtils.isNotEmpty(logicKeys) && logicKeys.size() == 1) {
                LOGGER.info("only exist shardingColumn value && logicKey.size == 1, so replace selectOne by SelectByLogicKey");
                returnRecod = this.selectByLogicKey(logicKeys.iterator().next());
            } else {
                LOGGER.error("\u8bf7\u6ce8\u610f\u8fd9\u91cc\uff0c\u5b58\u5728\u903b\u8f91\u4e3b\u952e\u4e14\u552f\u4e00\u6709\u503c\uff0c\u4e0d\u5e94\u8be5\u8d70\u8fd9\u4e2a\u67e5\u8be2\uff0c{}", logicKeys);
                returnRecod = this.getMapper().find(record);
            }
        } else {
            returnRecod = this.getMapper().find(record);
        }
        return returnRecod;
    }

    public List<T> selectByIds(List<Long> ids) {
        return this.getMapper().selectBatchIds(ids);
    }

    public int count(T record) {
        try {
            return this.getMapper().countCondition(record);
        }
        catch (Exception e) {
            if (RETHROW_EXCEPTION) {
                throw e;
            }
            LOGGER.error("\u67e5\u8be2\u8ba1\u6570\u51fa\u9519", (Throwable)e);
            return -1;
        }
    }

    public int insert(T record) {
        int effectRow = this.getMapper().insert(record);
        if (this.isUseCache()) {
            try {
                if (record.getId() != null) {
                    this.removeCache(this.getId(record));
                }
                this.removeLogicCache(record);
            }
            catch (Exception e) {
                LOGGER.error("inset \u64cd\u4f5c\u65f6\uff0c\u63d0\u524d\u5220\u9664\u4e24\u79cd\u952e\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            }
        }
        return effectRow;
    }

    public int update(T record) {
        int effectRows = this.getMapper().update(record);
        if (this.isUseCache()) {
            this.removeLogicCache(record);
            this.removeCache(this.getId(record));
            this.removeCacheByExample(record);
        }
        return effectRows;
    }

    public void removeLogicCache(T record) {
        Boolean result;
        if (!this.isUseCache()) {
            return;
        }
        if (record != null && (result = this.isExistLogicColumnOrShardingColumn(record.getClass())).booleanValue()) {
            Set<P> logicColumns = this.getLogicKey(record);
            if (CollectionUtils.isEmpty(logicColumns)) {
                logicColumns = this.processLogicColumns(record, logicColumns);
            }
            this.removeLogicCache(record, logicColumns);
        }
    }

    public int updateSelective(T record) {
        int effectRows = this.getMapper().updateSelective(record);
        if (this.isUseCache()) {
            this.removeLogicCache(record);
            this.removeCache(this.getId(record));
            this.removeCacheByExample(record);
        }
        return effectRows;
    }

    public int updateSelectiveSqlFilter(T record) {
        int effectRows = this.getMapper().updateSelectiveSqlFilter(record);
        if (this.isUseCache()) {
            try {
                this.removeLogicCache(record);
                this.removeCache(this.getId(record));
                this.removeCacheByExample(record);
            }
            catch (Exception e) {
                LOGGER.error("updateSelectiveSqlFilter \u79fb\u9664\u8bb0\u5f55 {} \u7f13\u5b58\u5931\u8d25", record, (Object)e);
            }
        }
        return effectRows;
    }

    public void delete(T record) {
        this.deleteByExample(record, false);
    }

    public void logicDelete(T record) {
        this.deleteByExample(record, true);
        this.removeLogicCache(record);
        this.removeCache(this.getId(record));
        this.removeCacheByExample(record);
    }

    public void deleteById(Long id) {
        T record = this.selectByPrimaryKey(id);
        this.getMapper().deleteById(id);
        this.removeLogicCache(record);
        this.removeCache(id);
        this.removeCacheByExample(record);
    }

    public void logicDeleteById(Long id) {
        T record = this.selectByPrimaryKey(id);
        this.removeLogicCache(record);
        this.removeCache(id);
        this.removeCacheByExample(record);
        this.getMapper().deleteLogicById(id);
    }

    public int logicDeleteByIds(List<Long> ids) {
        List records = this.getMapper().selectBatchIds(ids);
        if (CollectionUtils.isEmpty((Collection)records)) {
            return 0;
        }
        int effects = this.getMapper().deleteLogicBatchIds(ids.toArray(new Long[0]));
        for (BaseEo record : records) {
            Set<P> logicColumns = this.getLogicKey(record);
            if (CollectionUtils.isEmpty(logicColumns)) {
                logicColumns = this.processLogicColumns(record, logicColumns);
            }
            this.removeCache(this.getId(record));
            this.removeLogicCache(record, logicColumns);
            this.removeCacheByExample(record);
        }
        return effects;
    }

    public void logicDeleteByExample(T example) {
        this.deleteByExample(example, true);
    }

    public void deleteByExample(T example) {
        this.deleteByExample(example, false);
    }

    private int deleteByExample(T example, Boolean isLogicDelete) {
        BaseEo entity = BaseEo.newInstance(example.getClass());
        if (entity.equals(example)) {
            return 0;
        }
        List<T> records = this.select(example);
        if (CollectionUtils.isEmpty(records)) {
            return 0;
        }
        List<Long> ids = this.getIds(records);
        int effects = isLogicDelete != false ? this.getMapper().deleteLogicBatchIds(ids.toArray(new Long[0])) : this.getMapper().deleteBatchIds(ids.toArray(new Long[0]));
        for (BaseEo record : records) {
            Set<P> logicColumns = this.getLogicKey(record);
            if (CollectionUtils.isEmpty(logicColumns)) {
                logicColumns = this.processLogicColumns(record, logicColumns);
            }
            this.removeCache(this.getId(record));
            this.removeLogicCache(record, logicColumns);
            this.removeCacheByExample(record);
        }
        return effects;
    }

    public void deleteByLogicKey(P key) {
        this.removeCache(key);
        T record = this.setLogicKey(key);
        if (record == null) {
            throw new BizException("500", "Eo\u672a\u8bbe\u7f6e\u903b\u8f91\u4e3b\u952e");
        }
        this.getMapper().delete(record);
        this.removeLogicCache(record);
        this.removeCache(this.getId(record));
        this.removeCacheByExample(record);
    }

    public void logicDeleteByLogicKey(P key) {
        this.removeCache(key);
        T record = this.setLogicKey(key);
        if (record == null) {
            throw new BizException("500", "Eo\u672a\u8bbe\u7f6e\u903b\u8f91\u4e3b\u952e");
        }
        this.getMapper().deleteLogic(record);
        this.removeLogicCache(record);
        this.removeCache(this.getId(record));
        this.removeCacheByExample(record);
    }

    public int insertBatch(List<T> records) {
        if (records.isEmpty()) {
            return 0;
        }
        return this.getMapper().insertBatch(records);
    }

    public int updateBatch(List<T> records) {
        if (records.isEmpty()) {
            return 0;
        }
        return this.getMapper().updateBatch(records);
    }

    public List<Long> getIds(List<T> tList) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (BaseEo t : tList) {
            ids.add(t.getId());
        }
        return ids;
    }

    public int insertBatchByExample(List<T> tList, T example) {
        BaseEo entity = BaseEo.newInstance(example.getClass());
        if (entity.equals(example)) {
            return 0;
        }
        int effectRows = 0;
        if (tList.isEmpty()) {
            return effectRows;
        }
        effectRows = this.deleteByExample(example, false);
        return (effectRows += this.insertBatch(tList)) + tList.size();
    }

    public List<T> selectAll() {
        return this.getMapper().findAll();
    }

    public List<T> listByIds(Collection<? extends Serializable> idList) {
        return this.getMapper().selectBatchIds(idList);
    }

    public List<T> listByMap(Map<String, Object> columnMap) {
        return this.getMapper().selectByMap(columnMap);
    }

    public T getOne(Wrapper<T> queryWrapper) {
        return this.getOne(queryWrapper, true);
    }

    public T getOne(Wrapper<T> queryWrapper, boolean throwEx) {
        return (T)(throwEx ? (BaseEo)this.getMapper().selectOne(queryWrapper) : (BaseEo)SqlHelper.getObject((Log)this.ibatisLog, (List)this.baseMapper.selectList(queryWrapper)));
    }

    public int count() {
        return this.count((Wrapper<T>)Wrappers.emptyWrapper());
    }

    public int count(Wrapper<T> queryWrapper) {
        return SqlHelper.retCount((Integer)this.getMapper().selectCount(queryWrapper));
    }

    public List<T> list(Wrapper<T> queryWrapper) {
        return this.getMapper().selectList(queryWrapper);
    }

    public List<T> list() {
        return this.list((Wrapper<T>)Wrappers.emptyWrapper());
    }

    public ExtQueryChainWrapper<T> filter() {
        return this.filter(true);
    }

    public ExtQueryChainWrapper<T> filter(boolean isUseDr) {
        return new ExtQueryChainWrapper<T>(this.getMapper(), isUseDr);
    }

    public BaseMapper<T> getMapper() {
        if (this.baseMapper != null) {
            return this.baseMapper;
        }
        String tClassName = this.getTClassName();
        String firstSearchMapperName = tClassName.substring(0, 1).toLowerCase() + tClassName.substring(1, tClassName.length() - 2) + "Mapper";
        this.baseMapper = this.getMappers().get(firstSearchMapperName);
        String secondSearchMapperName = null;
        if (null == this.baseMapper) {
            secondSearchMapperName = tClassName.substring(0, tClassName.length() - 2) + "Mapper";
            this.baseMapper = this.getMappers().get(secondSearchMapperName);
        }
        if (this.baseMapper == null) {
            throw new RuntimeException(tClassName + "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684mapper:" + firstSearchMapperName + "/" + secondSearchMapperName);
        }
        return this.baseMapper;
    }

    public Class<T> getTClass() {
        Class<T> entityClass = this.getActualTypeArgument();
        if (entityClass == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684Eo\u5b9a\u4e49!!");
        }
        return entityClass;
    }

    protected Boolean isOnlyShardingColumnQueryEo(T record, String shardingProperty) {
        Boolean isOnlyShardingColumn = false;
        if (record != null) {
            List<Field> fields = BaseEoUtil.getAllFields(record.getClass());
            isOnlyShardingColumn = this.isOnlyShardingColumnByFeild(record, shardingProperty, fields);
        }
        return isOnlyShardingColumn;
    }

    private Boolean isOnlyShardingColumnByFeild(T record, String shardingProperty, List<Field> fields) {
        List filters;
        boolean isOnlyShardingColumn = false;
        HashSet<String> haveValueProperties = new HashSet<String>();
        for (Field field : fields) {
            if (IGNORE_SHARDING_FIELDS.contains(field.getName())) continue;
            try {
                field.setAccessible(true);
                Object obj = field.get(record);
                if (obj == null || field.getName().equals("extFields")) continue;
                haveValueProperties.add(field.getName());
            }
            catch (Exception e) {
                LOGGER.warn("\u83b7\u53d6\u6307\u5b9afield:{} \u5f02\u5e38:{}", (Object)field.getName(), (Object)e.getMessage());
            }
        }
        if (USE_META && MapUtils.isNotEmpty((Map)record.getExtFields())) {
            Map extFields = record.getExtFields();
            CustomTableInfo CustomTableInfo2 = BaseEoUtil.tableInfo(record.getClass());
            if (null != CustomTableInfo2) {
                for (String key : extFields.keySet()) {
                    if (IGNORE_SHARDING_FIELDS.contains(key) || null == CustomTableInfo2.getColumnInfo(key)) continue;
                    haveValueProperties.add(key);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(filters = record.getSqlFilters()))) {
            for (SqlFilter filter : filters) {
                Object obj;
                if (IGNORE_SHARDING_FIELDS.contains(CamelToUnderline.underlineToCamel((String)filter.getProperty())) || (obj = filter.getValue()) == null) continue;
                haveValueProperties.add(CamelToUnderline.underlineToCamel((String)filter.getProperty()));
            }
        }
        if (haveValueProperties.size() == 1 && haveValueProperties.contains(shardingProperty)) {
            isOnlyShardingColumn = true;
        }
        return isOnlyShardingColumn;
    }

    private String getTClassName() {
        return this.getTClass().getSimpleName();
    }

    protected Set<P> getLogicKey(T record) {
        Set logicKeyValues = new HashSet();
        if (record != null) {
            List sqlFilters = record.getSqlFilters();
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            if (CollectionUtils.isNotEmpty((Collection)sqlFilters)) {
                for (SqlFilter sqlFilter : sqlFilters) {
                    if (sqlFilter.getProperty() == null || sqlFilter.getValue() == null) continue;
                    filterMap.put(sqlFilter.getProperty(), sqlFilter.getValue());
                    filterMap.put(CamelToUnderline.underlineToCamel((String)sqlFilter.getProperty()), sqlFilter.getValue());
                }
            }
            logicKeyValues = USE_META ? this.getLogicKeyByMeta(record, logicKeyValues, filterMap) : this.getLogicKeyByReflect(record, logicKeyValues, filterMap);
        }
        return logicKeyValues;
    }

    private Set<P> getLogicKeyByReflect(T record, Set<P> logicKeyValues, Map<String, Object> filterMap) {
        String propertyName = this.getShardingProperties(record.getClass());
        List<Field> fields = BaseEoUtil.getAllFields(record.getClass());
        for (Field field : fields) {
            if (!field.isAnnotationPresent(LogicColumn.class) && !field.getName().equals(propertyName)) continue;
            field.setAccessible(true);
            Object objectValue = null;
            try {
                objectValue = field.get(record);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("\u83b7\u53d6\u903b\u8f91\u4e3b\u952e\u51fa\u9519", (Throwable)e);
            }
            if (objectValue == null && filterMap.size() > 0 && filterMap.containsKey(field.getName())) {
                objectValue = filterMap.get(field.getName());
                if (objectValue instanceof String) {
                    String[] logicKeyValueStrs = StrUtil.split((CharSequence)String.valueOf(objectValue), (CharSequence)",");
                    if (null != logicKeyValueStrs && logicKeyValueStrs.length > 0) {
                        for (String logicKeyValue : logicKeyValueStrs) {
                            if (logicKeyValue == null) continue;
                            logicKeyValues.add(logicKeyValue);
                        }
                    }
                } else if (objectValue instanceof List) {
                    List listFilterValues = (List)objectValue;
                    logicKeyValues.addAll(listFilterValues);
                } else {
                    logicKeyValues.add(objectValue);
                }
            } else {
                logicKeyValues.add(objectValue);
            }
            return logicKeyValues;
        }
        return logicKeyValues;
    }

    private Set<P> getLogicKeyByMeta(T record, Set<P> logicKeyValues, Map<String, Object> filterMap) {
        String shardingColumnName = this.getShardingProperties(record.getClass());
        String logicColumnName = this.getLogicProperties(record.getClass());
        if (null == shardingColumnName && null == logicColumnName) {
            return logicKeyValues;
        }
        HashSet<String> columnNames = new HashSet<String>();
        if (null != shardingColumnName) {
            columnNames.add(shardingColumnName);
        }
        if (null != logicColumnName) {
            columnNames.add(logicColumnName);
        }
        for (String columnName : columnNames) {
            Object objectValue = this.getFieldValue(record.getClass(), record, columnName);
            if (null == objectValue) {
                if (filterMap.size() <= 0 || !filterMap.containsKey(columnName)) continue;
                objectValue = filterMap.get(columnName);
                if (objectValue instanceof String) {
                    String[] logicKeyValueStrs = StrUtil.split((CharSequence)String.valueOf(objectValue), (CharSequence)",");
                    if (null == logicKeyValueStrs || logicKeyValueStrs.length <= 0) continue;
                    for (String logicKeyValue : logicKeyValueStrs) {
                        if (logicKeyValue == null) continue;
                        logicKeyValues.add(logicKeyValue);
                    }
                    continue;
                }
                if (objectValue instanceof List) {
                    List listFilterValues = (List)objectValue;
                    logicKeyValues.addAll(listFilterValues);
                    continue;
                }
                logicKeyValues.add(objectValue);
                continue;
            }
            logicKeyValues.add(objectValue);
        }
        return logicKeyValues;
    }

    private <T extends BaseEo> Object getFieldValue(Class<?> aClass, T obj, String fieldName) {
        Map extFields;
        Object fieldValue = null;
        Class<?> clazz = aClass;
        while (clazz != Object.class) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                fieldValue = field.get(obj);
                break;
            }
            catch (NoSuchFieldException ex) {
                clazz = clazz.getSuperclass();
            }
            catch (IllegalAccessException ex) {
            }
        }
        if (null == fieldValue && USE_META && null != obj && null != (extFields = obj.getExtFields()) && extFields.containsKey(fieldName)) {
            fieldValue = extFields.get(fieldName);
        }
        return fieldValue;
    }

    private String getShardingProperties(Class<? extends BaseEo> recordClass) {
        CustomTableInfo CustomTableInfo2;
        if (USE_META) {
            // empty if block
        }
        if (null != (CustomTableInfo2 = BaseEoUtil.tableInfo(recordClass)) && !StrUtil.isEmpty((CharSequence)CustomTableInfo2.getShardingColumnName())) {
            return CustomTableInfo2.getShardingColumnName();
        }
        return null;
    }

    private String getLogicProperties(Class<? extends BaseEo> recordClass) {
        CustomTableInfo CustomTableInfo2;
        if (USE_META) {
            // empty if block
        }
        if (null != (CustomTableInfo2 = BaseEoUtil.tableInfo(recordClass)) && !StrUtil.isEmpty((CharSequence)CustomTableInfo2.getLogicColumnName())) {
            return CustomTableInfo2.getLogicColumnName();
        }
        return null;
    }

    private Set<Long> getId(T record) {
        HashSet<Long> ids = new HashSet<Long>();
        if (record != null) {
            if (record.getId() != null) {
                ids.add(record.getId());
                return ids;
            }
            List sqlFilters = record.getSqlFilters();
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            if (CollectionUtils.isNotEmpty((Collection)sqlFilters)) {
                for (SqlFilter sqlFilter : sqlFilters) {
                    if (sqlFilter.getProperty() == null || sqlFilter.getValue() == null) continue;
                    filterMap.put(sqlFilter.getProperty(), sqlFilter.getValue());
                    filterMap.put(CamelToUnderline.underlineToCamel((String)sqlFilter.getProperty()), sqlFilter.getValue());
                }
            }
            List<Field> fields = BaseEoUtil.getAllFields(record.getClass());
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Id.class)) continue;
                field.setAccessible(true);
                Object objectValue = null;
                try {
                    objectValue = field.get(record);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("\u83b7\u53d6\u4e3b\u952e\u51fa\u9519", (Throwable)e);
                }
                if (objectValue == null && filterMap.size() > 0 && filterMap.containsKey(field.getName())) {
                    objectValue = filterMap.get(field.getName());
                    if (objectValue instanceof String) {
                        String[] idStrs = StrUtil.split((CharSequence)String.valueOf(objectValue), (CharSequence)",");
                        if (null != idStrs && idStrs.length > 0) {
                            for (String idStr : idStrs) {
                                ids.add(Long.valueOf(idStr));
                            }
                        }
                    } else if (objectValue instanceof List) {
                        List listFilterValues = (List)objectValue;
                        ids.addAll(listFilterValues);
                    } else {
                        ids.add((Long)objectValue);
                    }
                } else {
                    ids.add((Long)objectValue);
                }
                return ids;
            }
        }
        return ids;
    }

    private T setLogicKey(P key) {
        if (key != null) {
            Class<T> entityClass = this.getTClass();
            Boolean existFields = false;
            try {
                BaseEo record = (BaseEo)entityClass.newInstance();
                List<Field> fields = BaseEoUtil.getAllFields(record.getClass());
                for (Field field : fields) {
                    if (!field.isAnnotationPresent(LogicColumn.class) && !field.getName().equals(this.getShardingProperties(entityClass))) continue;
                    existFields = true;
                    field.setAccessible(true);
                    if (key.getClass().equals(field.getType())) {
                        field.set(record, key);
                        break;
                    }
                    if (field.getType().equals(Long.class)) {
                        field.set(record, Long.parseLong(key.toString()));
                        break;
                    }
                    field.set(record, key.toString());
                    break;
                }
                if (!existFields.booleanValue() && USE_META) {
                    Map<String, Object> extFields;
                    CustomTableInfo CustomTableInfo2 = BaseEoUtil.tableInfo(entityClass);
                    if (null != CustomTableInfo2 && !StrUtil.isEmpty((CharSequence)CustomTableInfo2.getShardingColumnName())) {
                        extFields = record.getExtFields();
                        if (null == extFields) {
                            extFields = new HashMap<String, P>();
                            record.setExtFields(extFields);
                        }
                        extFields.put(CustomTableInfo2.getShardingColumnName(), key);
                        return (T)record;
                    }
                    if (null != CustomTableInfo2 && !StrUtil.isEmpty((CharSequence)CustomTableInfo2.getLogicColumnName())) {
                        extFields = record.getExtFields();
                        if (null == extFields) {
                            extFields = new HashMap();
                            record.setExtFields(extFields);
                        }
                        extFields.put(CustomTableInfo2.getLogicColumnName(), key);
                        return (T)record;
                    }
                }
                if (existFields.booleanValue()) {
                    return (T)record;
                }
            }
            catch (Exception e) {
                LOGGER.error("\u8bbe\u7f6e\u903b\u8f91\u4e3b\u952e\u51fa\u9519", (Throwable)e);
            }
        }
        return null;
    }

    public String getCachePre() {
        return this.getActualArgumentClassName() + this.getVersion();
    }

    public String getLogicCachePre() {
        return this.getActualArgumentClassName() + "_LOGIC_" + this.getVersion();
    }

    private String getActualArgumentClassName() {
        Class<T> entityClass = this.getActualTypeArgument();
        return entityClass.getSimpleName();
    }

    public void addCache(T record, Object key) {
        if (!this.isUseCache()) {
            return;
        }
        if (record == null || key == null) {
            LOGGER.error("\u6dfb\u52a0\u7f13\u5b58\u5931\u8d25,record:{},key:{}", record, key);
            return;
        }
        try {
            this.getCacheService().setCache(this.getCachePre() + key, record);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u7f13\u5b58\u5931\u8d25,record=" + record, (Throwable)e);
        }
    }

    public void addLogicCache(T record, Object key) {
        if (!this.isUseCache()) {
            return;
        }
        if (record == null || key == null) {
            LOGGER.error("\u6dfb\u52a0\u903b\u8f91\u7f13\u5b58\u5931\u8d25,record:{},key:{}", record, key);
            return;
        }
        try {
            this.getCacheService().setCache(this.getLogicCachePre() + key, record);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u903b\u8f91\u7f13\u5b58\u5931\u8d25,record=" + record, (Throwable)e);
        }
    }

    public void addEmptyCache(Object key) {
        if (!this.isUseCache()) {
            return;
        }
        this.addEmptyCache(key, EMPTY_CACHE_SECONDS);
    }

    public void addEmptyCache(Object key, Integer seconds) {
        if (!this.isUseCache()) {
            return;
        }
        try {
            BaseEo record = (BaseEo)this.getTClass().newInstance();
            record.setId(EMPTY_ID);
            if (seconds != null) {
                this.getCacheService().setCache(this.getCachePre() + key, (Object)record, seconds.intValue());
            } else {
                this.getCacheService().setCache(this.getCachePre() + key, (Object)record);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u7a7a\u7f13\u5b58\u5931\u8d25,key:{}", key, (Object)e);
        }
    }

    public void addLogicEmptyCache(Object key, Integer seconds) {
        if (!this.isUseCache()) {
            return;
        }
        try {
            BaseEo record = (BaseEo)this.getTClass().newInstance();
            record.setId(EMPTY_ID);
            if (seconds != null) {
                this.getCacheService().setCache(this.getLogicCachePre() + key, (Object)record, seconds.intValue());
            } else {
                this.getCacheService().setCache(this.getLogicCachePre() + key, (Object)record);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u7a7a\u7f13\u5b58\u5931\u8d25,key:{}", key, (Object)e);
        }
    }

    public T getCacheByKey(Object key) {
        if (!this.isUseCache()) {
            return null;
        }
        try {
            return (T)((BaseEo)this.getCacheService().getCache(this.getCachePre() + key, this.getActualTypeArgument()));
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u4e3b\u952e\u83b7\u53d6\u7f13\u5b58\u5931\u8d25\uff0c\u4e3b\u952e=" + key, (Throwable)e);
            return null;
        }
    }

    private Class<T> getActualTypeArgument() {
        return EoUtil.getGenericClass(this.getClass());
    }

    public T getCacheByLogicKey(Object key) {
        if (!this.isUseCache()) {
            return null;
        }
        try {
            return (T)((BaseEo)this.getCacheService().getCache(this.getLogicCachePre() + key, this.getActualTypeArgument()));
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u903b\u8f91\u4e3b\u952e\u83b7\u53d6\u7f13\u5b58\u5931\u8d25\uff0c\u903b\u8f91\u4e3b\u952e=" + key, (Throwable)e);
            return null;
        }
    }

    public void removeCache(Object key) {
        if (!this.isUseCache()) {
            return;
        }
        try {
            if (key instanceof Set) {
                Set keys = (Set)key;
                ArrayList<String> ids = new ArrayList<String>(keys.size());
                for (Object o : keys) {
                    ids.add(this.getCachePre() + o);
                }
                this.getCacheService().delCache(ids);
            } else {
                this.getCacheService().delCache(this.getCachePre() + key);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    public void removeLogicCache(T record, Set<P> logicColumns) {
        if (!this.isUseCache()) {
            return;
        }
        if (record != null && logicColumns != null) {
            ArrayList<String> ids = new ArrayList<String>(logicColumns.size());
            for (P key : logicColumns) {
                ids.add(this.getLogicCachePre() + key);
            }
            this.getCacheService().delCache(ids);
        }
    }

    public void removeCacheByExample(T record) {
        if (!this.isUseCache()) {
            return;
        }
        if (record != null) {
            Set<P> keys = this.getLogicKey(record);
            if (keys != null) {
                ArrayList<String> ids = new ArrayList<String>(keys.size());
                for (P key : keys) {
                    ids.add(this.getCachePre() + key);
                }
                this.getCacheService().delCache(ids);
            }
            if (CollectionUtil.isNotEmpty((Collection)record.getSqlFilters())) {
                this.removeCacheBySqlFilters(record);
            }
        }
    }

    private void removeCacheBySqlFilters(T record) {
        for (SqlFilter filter : record.getSqlFilters()) {
            if (!filter.getProperty().equals("id") || !filter.getOperator().equals((Object)SqlFilter.Operator.in)) continue;
            Object filterValue = filter.getValue();
            Collection<Object> inValues = null;
            inValues = filterValue instanceof Collection ? (List<Object>)filterValue : (filterValue instanceof String ? (Collection)Stream.of(((String)filterValue).split(",")).map(str -> str.replaceAll("'", "")).collect(Collectors.toList()) : (filterValue instanceof String[] ? (Collection)Stream.of((String[])filterValue).map(str -> str.replaceAll("'", "")).collect(Collectors.toList()) : (filterValue.getClass().isArray() ? Arrays.asList(ParamConverter.objectToArray((Object)filterValue)) : Arrays.asList(filterValue))));
            ArrayList<String> ids = new ArrayList<String>(inValues.size());
            for (Object e : inValues) {
                ids.add(this.getCachePre() + e);
            }
            this.getCacheService().delCache(ids);
            break;
        }
    }

    public boolean isUseCache() {
        return USE_CACHE && !this.entityUnderControl;
    }

    private Set<P> processLogicColumns(T record, Set<P> logicColumns) {
        T cacheRecord;
        if (CollectionUtils.isEmpty(logicColumns) && CollectionUtils.isEmpty(logicColumns = this.getLogicKey(cacheRecord = this.getCacheByKey(record.getId())))) {
            LOGGER.warn("load logic key by select DB for delete cache");
            T dbRecord = this.selectByPrimaryKey(record.getId());
            logicColumns = this.getLogicKey(dbRecord);
        }
        return logicColumns;
    }

    private Boolean isExistLogicColumnOrShardingColumn(Class<? extends BaseEo> recordClass) {
        Boolean existsLogicOrShardingColumn = LOGIC_OR_SHARDING_COLUMN_EOS.get(recordClass.getName());
        if (existsLogicOrShardingColumn != null) {
            return existsLogicOrShardingColumn;
        }
        String shardingPropertyName = this.getShardingProperties(recordClass);
        if (null != shardingPropertyName) {
            LOGIC_OR_SHARDING_COLUMN_EOS.put(recordClass.getName(), true);
            return true;
        }
        String logicPropertyName = this.getLogicProperties(recordClass);
        if (null != logicPropertyName) {
            LOGIC_OR_SHARDING_COLUMN_EOS.put(recordClass.getName(), true);
            return true;
        }
        LOGIC_OR_SHARDING_COLUMN_EOS.put(recordClass.getName(), false);
        return false;
    }

    public boolean isEntityUnderControl() {
        return this.entityUnderControl;
    }

    public void setEntityUnderControl(boolean entityUnderControl) {
        this.entityUnderControl = entityUnderControl;
    }
}

