/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.mybatis;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.dtyunxi.cube.starter.mybatis.MyDataSourceProperties;
import com.dtyunxi.huieryun.dao.mybatis.config.ConditionalOnDaoMybatis;
import com.dtyunxi.huieryun.dao.mybatis.config.CustomMybatisPlusAutoConfiguration;
import com.dtyunxi.huieryun.datasource.DruidDataSourceHelper;
import com.dtyunxi.huieryun.transaction.DrdsTransactionManager;
import com.dtyunxi.huieryun.vo.DataSourceVo;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.mybatis.spring.boot.autoconfigure.MybatisProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@ConditionalOnDaoMybatis
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class, CustomMybatisPlusAutoConfiguration.class, MybatisPlusAutoConfiguration.class})
@EnableTransactionManagement
public class DataSourceConfig {
    public static final String TRANSACTION_MANAGER = "dataSourceTransactionManager";
    @Autowired
    protected ApplicationContext context;

    @Bean
    @ConfigurationProperties(prefix="yundt.cube.center.datasource")
    @ConditionalOnMissingBean
    public MyDataSourceProperties myDataSourceProperties() {
        return new MyDataSourceProperties();
    }

    @ConditionalOnMissingBean(value={DataSource.class})
    @ConditionalOnBean(value={MyDataSourceProperties.class})
    @Bean
    public DataSource dataSource(MyDataSourceProperties dataSourceVo, @Value(value="${druid.connection.properties:}") String connectionProperties, @Value(value="${druid.stat.mergeSql:true}") boolean mergeSql) throws SQLException {
        return DruidDataSourceHelper.createDruidDataSource(dataSourceVo, connectionProperties, mergeSql);
    }

    @Bean(name={"dataSourceTransactionManager"})
    @ConditionalOnMissingBean
    public PlatformTransactionManager dataSourceTransactionManager(ObjectProvider<DataSourceVo> dataSourceVoProvider, DataSource dataSource) {
        DataSourceVo dataSourceVo = (DataSourceVo)((Object)dataSourceVoProvider.getIfAvailable());
        boolean isDrds = dataSourceVo != null ? dataSourceVo.isDrds() : false;
        return new DrdsTransactionManager(dataSource, isDrds);
    }

    public MybatisProperties getMybatisVo() {
        return (MybatisProperties)this.context.getBean(MybatisProperties.class);
    }

    public MyDataSourceProperties getDataSourceVo() {
        return (MyDataSourceProperties)((Object)this.context.getBean(MyDataSourceProperties.class));
    }
}

