/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.dao.mybatis.support.mybatis;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.dao.entity.Entity;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyMetaObjectHandler
implements MetaObjectHandler {
    private static final Logger logger = LoggerFactory.getLogger(MyMetaObjectHandler.class);

    public void insertFill(MetaObject metaObject) {
        try {
            String requestUserCode = (String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"");
            if (metaObject.hasSetter("tenantId")) {
                Long tenantId = (Long)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestTenantId(), (Object)-1L);
                this.fillStrategy(metaObject, "tenantId", tenantId);
            }
            if (metaObject.hasSetter("instanceId")) {
                Long instanceId = (Long)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestInstanceId(), (Object)-1L);
                this.fillStrategy(metaObject, "instanceId", instanceId);
            }
            if (metaObject.getOriginalObject() instanceof BaseEo) {
                Date currentDate = new Date();
                this.fillStrategy(metaObject, "createPerson", requestUserCode);
                this.fillStrategy(metaObject, "createTime", currentDate);
                this.fillStrategy(metaObject, "updatePerson", requestUserCode);
                this.fillStrategy(metaObject, "updateTime", currentDate);
                this.fillStrategy(metaObject, "dr", 0);
                return;
            }
            if (metaObject.getOriginalObject() instanceof Entity) {
                this.fillStrategy(metaObject, "createTime", LocalDateTime.now());
                this.fillStrategy(metaObject, "updateTime", LocalDateTime.now());
                this.fillStrategy(metaObject, "createBy", requestUserCode);
                this.fillStrategy(metaObject, "updateBy", requestUserCode);
                return;
            }
        }
        catch (Exception e) {
            logger.error("insertFill failure!", (Throwable)e);
        }
    }

    public void updateFill(MetaObject metaObject) {
        if (metaObject.getOriginalObject() instanceof BaseEo) {
            return;
        }
        if (metaObject.getOriginalObject() instanceof Entity) {
            String requestUserCode = (String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"");
            this.strictUpdateFill(metaObject, "updateBy", String.class, requestUserCode);
            this.strictUpdateFill(metaObject, "updateTime", LocalDateTime.class, LocalDateTime.now());
            return;
        }
    }
}

