/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datasubscribe.provider;

import com.dtyunxi.huieryun.datasubscribe.provider.DataSubcribeEventListener;
import com.dtyunxi.huieryun.datasubscribe.provider.canal.CanalClient;
import com.dtyunxi.huieryun.datasubscribe.provider.canal.CanalConfig;
import com.dtyunxi.huieryun.datasubscribe.provider.canal.CanalDataSubscribeService;
import com.dtyunxi.huieryun.datasubscribe.provider.dts.DtsClient;
import com.dtyunxi.huieryun.datasubscribe.provider.dts.DtsConfig;
import com.dtyunxi.huieryun.datasubscribe.provider.dts.DtsDataSubscribeService;
import com.dtyunxi.huieryun.datasubscribe.vo.DataSubscribeRegistryVo;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.lang.BusinessException;
import org.slf4j.Logger;

public class DataSubscribeServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(DataSubscribeServiceFactory.class);

    public static void createDataSubscribeService(DataSubscribeRegistryVo registryVo, DataSubcribeEventListener eventListener) throws BusinessException {
        switch (registryVo.getType()) {
            case "canal": {
                CanalConfig canalConfig = new CanalConfig(registryVo);
                CanalClient canalClient = new CanalClient(canalConfig);
                CanalDataSubscribeService canalDataSubscribeService = new CanalDataSubscribeService(canalClient, eventListener);
                Thread canalThread = new Thread(canalDataSubscribeService);
                canalThread.setName("CanalDataSubscribeServiceThread");
                canalThread.start();
                logger.info("Use canal subscribe data.");
                break;
            }
            case "dts": {
                DtsConfig dtsConfig = new DtsConfig(registryVo);
                DtsClient dtsClient = new DtsClient(dtsConfig);
                DtsDataSubscribeService dtsDataSubscribeService = new DtsDataSubscribeService(dtsClient, eventListener);
                Thread dtsThread = new Thread(dtsDataSubscribeService);
                dtsThread.setName("DtsDataSubscribeServiceThread");
                dtsThread.start();
                logger.info("Use dts subscribe data.");
                break;
            }
            default: {
                throw new BusinessException("Data subscribe type error !");
            }
        }
    }
}

