/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.constant;

import com.dtyunxi.lang.BusinessRuntimeException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcExceptionCode {
    private static Logger logger = LoggerFactory.getLogger(RpcExceptionCode.class);
    public static final String CODE_SYS_ERROR = ExceptionCodeType.SYS.getCodeType() + "000";
    public static final String CODE_INVALID_PARAM = ExceptionCodeType.BIZ.getCodeType() + "000";
    protected static Map<String, String> codeMap = new HashMap<String, String>();

    protected static void addCodeMap(String code, String msg) {
        if (codeMap.containsKey(code)) {
            logger.error("\u6dfb\u52a0\u9519\u8bef\u7801\u5931\u8d25,\u9519\u8bef\u7801\u5df2\u5b58\u5728:{}", (Object)code);
            throw new BusinessRuntimeException("\u6dfb\u52a0\u9519\u8bef\u7801\u5931\u8d25,\u9519\u8bef\u7801\u5df2\u5b58\u5728:" + code);
        }
        if (!ExceptionCodeType.isCodePrefixExist(code)) {
            logger.error("\u6dfb\u52a0\u9519\u8bef\u7801\u5931\u8d25,\u9519\u8bef\u7f16\u7801\u524d\u7f00\u672a\u5b9a\u4e49:{}", (Object)code);
            throw new BusinessRuntimeException("\u6dfb\u52a0\u9519\u8bef\u7801\u5931\u8d25,\u9519\u8bef\u7f16\u7801\u524d\u7f00\u672a\u5b9a\u4e49:" + code);
        }
        codeMap.put(code, msg);
    }

    public static String getExceptionMsg(String exceptionCode) {
        if (!ExceptionCodeType.isCodePrefixExist(exceptionCode)) {
            logger.warn("\u9519\u8bef\u7f16\u7801\u524d\u7f00\u672a\u5b9a\u4e49:{}", (Object)exceptionCode);
        }
        return codeMap.get(exceptionCode);
    }

    static {
        codeMap.put(CODE_SYS_ERROR, "Internal error");
        codeMap.put(CODE_INVALID_PARAM, "Biz parameter invalid");
    }

    public static enum ExceptionCodeType {
        SYS("100", "\u7cfb\u7edf\u7c7b\u5f02\u5e38"),
        BIZ("200", "\u4e1a\u52a1\u7c7b\u5f02\u5e38"),
        CENTER_ITEM("300", "\u5546\u54c1\u4e2d\u5fc3\u5f02\u5e38");

        private String codeType;
        private String desc;
        private static Map<String, String> map;

        public static boolean isCodePrefixExist(String code) {
            for (String codePrefix : map.keySet()) {
                if (!code.contains(codePrefix)) continue;
                return true;
            }
            return false;
        }

        private ExceptionCodeType(String codeType, String desc) {
            this.codeType = codeType;
            this.desc = desc;
        }

        public String getCodeType() {
            return this.codeType;
        }

        public void setCodeType(String codeType) {
            this.codeType = codeType;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        static {
            map = new HashMap<String, String>();
            for (ExceptionCodeType prefix : ExceptionCodeType.values()) {
                map.put(prefix.getCodeType(), prefix.getDesc());
            }
        }
    }
}

