/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.json.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class CustomFloatSerializer
implements ObjectSerializer {
    public static final CustomFloatSerializer instance = new CustomFloatSerializer();
    private NumberFormat decimalFormat;

    public CustomFloatSerializer() {
    }

    public CustomFloatSerializer(NumberFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public CustomFloatSerializer(String decimalFormat) {
        this(new DecimalFormat(decimalFormat));
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        float floatValue = ((Float)object).floatValue();
        if (this.decimalFormat != null) {
            String floatText = this.decimalFormat.format(floatValue);
            out.write(floatText);
        } else {
            out.writeFloat(floatValue, false);
        }
    }
}

