/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.CustomListSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.spi.Module;
import com.dtyunxi.json.serializer.CustomDoubleSerializer;
import com.dtyunxi.json.serializer.CustomFloatSerializer;
import com.dtyunxi.json.serializer.CustomIntegerSerializer;
import com.dtyunxi.json.serializer.CustomLongSerializer;
import java.lang.reflect.Type;
import java.util.List;

public class FastJsonUtil {
    private static final SerializeConfig serializeConfig = new SerializeConfig();
    private static final ParserConfig parserConfig = new ParserConfig();

    public static String toJSONString(Object object) {
        return JSONObject.toJSONString((Object)object, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName});
    }

    public static <T> T parseObject(String jsonStr, Class<T> clazz) {
        return (T)JSON.parseObject((String)jsonStr, clazz, (ParserConfig)parserConfig, (Feature[])new Feature[0]);
    }

    public static <T> T parseObject(String jsonStr, Type type) {
        return (T)JSON.parseObject((String)jsonStr, (Type)type, (ParserConfig)parserConfig, (Feature[])new Feature[0]);
    }

    static {
        serializeConfig.put(Double.class, (ObjectSerializer)CustomDoubleSerializer.instance);
        serializeConfig.put(Float.class, (ObjectSerializer)CustomFloatSerializer.instance);
        serializeConfig.put(Byte.class, (ObjectSerializer)CustomIntegerSerializer.instance);
        serializeConfig.put(Short.class, (ObjectSerializer)CustomIntegerSerializer.instance);
        serializeConfig.put(Long.class, (ObjectSerializer)CustomLongSerializer.instance);
        serializeConfig.register(new Module(){

            public ObjectDeserializer createDeserializer(ParserConfig config, Class type) {
                return null;
            }

            public ObjectSerializer createSerializer(SerializeConfig config, Class type) {
                if (List.class.isAssignableFrom(type)) {
                    return CustomListSerializer.instance;
                }
                return null;
            }
        });
        parserConfig.setAutoTypeSupport(true);
    }
}

