/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.identity.auth.api;

import com.dtyunxi.huieryun.identity.vo.LoginVo;
import com.dtyunxi.util.CookieUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthTokenUtil {
    private static final Logger logger = LoggerFactory.getLogger(AuthTokenUtil.class);

    public static LoginVo decodeToken(String authToken) {
        LoginVo loginVo = null;
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey("{name:userCenter,use:app,auth:virify}").parseClaimsJws(authToken).getBody();
            String key = claims.getSubject();
            logger.debug("api authTokenUtil decodeToken {}", (Object)key);
            String[] keyArray = key.split("&__&");
            if (keyArray != null && keyArray.length > 3) {
                loginVo = new LoginVo();
                loginVo.setAppId(keyArray[1]);
                loginVo.setUserId(Long.valueOf(keyArray[2]));
                loginVo.setUserCode(keyArray[3]);
                loginVo.setOpenId(keyArray[4]);
                loginVo.setUserType(keyArray[5]);
                if (keyArray.length > 6) {
                    loginVo.setTrench(keyArray[6]);
                }
                if (keyArray.length > 7) {
                    loginVo.setTenantId(Long.valueOf(keyArray[7]));
                }
                if (keyArray.length > 8) {
                    loginVo.setApplicationId(Long.valueOf(keyArray[8]));
                }
                loginVo.setAuthKey(key);
            }
        }
        catch (Exception e) {
            logger.error("\u5ffd\u7565\u5f02\u5e38\uff1adecodeToken error message {}", (Throwable)e);
        }
        return loginVo;
    }

    public static String getAuthToken(HttpServletRequest httpRequest) {
        String authToken = httpRequest.getHeader("auth");
        if (StringUtils.isBlank((CharSequence)authToken) && StringUtils.isEmpty((CharSequence)(authToken = httpRequest.getParameter("auth")))) {
            try {
                Cookie cookie = CookieUtil.getCookieByName((HttpServletRequest)httpRequest);
                authToken = cookie.getValue();
            }
            catch (Exception e) {
                logger.error("\u7f3a\u5c11auth\u8bf7\u6c42\u53c2\u6570");
            }
        }
        return authToken;
    }
}

