/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd;

import com.coreos.jetcd.EtcdAuth;
import com.coreos.jetcd.EtcdAuthImpl;
import com.coreos.jetcd.EtcdClientBuilder;
import com.coreos.jetcd.EtcdCluster;
import com.coreos.jetcd.EtcdClusterImpl;
import com.coreos.jetcd.EtcdKV;
import com.coreos.jetcd.EtcdKVImpl;
import com.coreos.jetcd.EtcdMaintenance;
import com.coreos.jetcd.EtcdMaintenanceImpl;
import com.coreos.jetcd.api.AuthGrpc;
import com.coreos.jetcd.api.AuthenticateRequest;
import com.coreos.jetcd.api.AuthenticateResponse;
import com.coreos.jetcd.api.ClusterGrpc;
import com.coreos.jetcd.api.KVGrpc;
import com.coreos.jetcd.api.MaintenanceGrpc;
import com.coreos.jetcd.api.WatchGrpc;
import com.coreos.jetcd.exception.AuthFailedException;
import com.coreos.jetcd.exception.ConnectException;
import com.coreos.jetcd.resolver.AbstractEtcdNameResolverFactory;
import com.coreos.jetcd.resolver.SimpleEtcdNameResolverFactory;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import io.grpc.Attributes;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.NameResolver;
import io.grpc.stub.AbstractStub;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

public class EtcdClient {
    private static final String TOKEN = "token";
    private final ManagedChannelBuilder<?> channelBuilder;
    private final String[] endpoints;
    private final ManagedChannel channel;
    private final AbstractEtcdNameResolverFactory nameResolverFactory;
    private final EtcdKV kvClient;
    private final EtcdAuth authClient;
    private final EtcdMaintenance maintenanceClient;
    private final EtcdCluster clusterClient;
    private KVGrpc.KVFutureStub kvStub;
    private AuthGrpc.AuthFutureStub authStub;
    private WatchGrpc.WatchStub watchStub;

    public EtcdClient(ManagedChannelBuilder<?> channelBuilder, EtcdClientBuilder builder) throws ConnectException, AuthFailedException {
        if (builder.getNameResolverFactory() != null) {
            this.endpoints = null;
            this.nameResolverFactory = builder.getNameResolverFactory();
        } else {
            this.endpoints = new String[builder.endpoints().size()];
            builder.endpoints().toArray(this.endpoints);
            this.nameResolverFactory = this.getSimpleNameResolveFactory(this.endpoints);
        }
        this.channelBuilder = channelBuilder != null ? channelBuilder : ManagedChannelBuilder.forTarget((String)"etcd").nameResolverFactory((NameResolver.Factory)this.nameResolverFactory).usePlaintext(true);
        this.channel = this.channelBuilder.build();
        this.kvStub = KVGrpc.newFutureStub((Channel)this.channel);
        this.authStub = AuthGrpc.newFutureStub((Channel)this.channel);
        MaintenanceGrpc.MaintenanceFutureStub mainFStub = MaintenanceGrpc.newFutureStub((Channel)this.channel);
        MaintenanceGrpc.MaintenanceStub mainStub = MaintenanceGrpc.newStub((Channel)this.channel);
        ClusterGrpc.ClusterFutureStub clusterStub = ClusterGrpc.newFutureStub((Channel)this.channel);
        this.watchStub = WatchGrpc.newStub((Channel)this.channel);
        String token = this.getToken(builder);
        if (token != null) {
            this.authStub = this.setTokenForStub(this.authStub, token);
            this.kvStub = this.setTokenForStub(this.kvStub, token);
            mainFStub = this.setTokenForStub(mainFStub, token);
            mainStub = this.setTokenForStub(mainStub, token);
            clusterStub = this.setTokenForStub(clusterStub, token);
            this.watchStub = this.setTokenForStub(this.watchStub, token);
        }
        this.kvClient = this.newKVClient(this.kvStub);
        this.authClient = this.newAuthClient(this.authStub);
        this.maintenanceClient = this.newMaintenanceClient(mainFStub, mainStub);
        this.clusterClient = this.newClusterClient(clusterStub);
    }

    private EtcdKV newKVClient(KVGrpc.KVFutureStub stub) {
        return new EtcdKVImpl(stub);
    }

    private EtcdAuth newAuthClient(AuthGrpc.AuthFutureStub stub) {
        return new EtcdAuthImpl(stub);
    }

    private EtcdCluster newClusterClient(ClusterGrpc.ClusterFutureStub stub) {
        return new EtcdClusterImpl(stub);
    }

    private EtcdMaintenance newMaintenanceClient(MaintenanceGrpc.MaintenanceFutureStub futureStub, MaintenanceGrpc.MaintenanceStub stub) {
        return new EtcdMaintenanceImpl(futureStub, stub);
    }

    public EtcdAuth getAuthClient() {
        return this.authClient;
    }

    public EtcdKV getKVClient() {
        return this.kvClient;
    }

    public EtcdCluster getClusterClient() {
        return this.clusterClient;
    }

    public EtcdMaintenance getMaintenanceClient() {
        return this.maintenanceClient;
    }

    public WatchGrpc.WatchStub getWatchStub() {
        return this.watchStub;
    }

    private <T extends AbstractStub<?>> T setTokenForStub(T stub, String token) {
        final Metadata metadata = new Metadata();
        Metadata.Key TOKEN_KEY = Metadata.Key.of((String)TOKEN, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        metadata.put(TOKEN_KEY, (Object)token);
        CallCredentials callCredentials = new CallCredentials(){

            public void applyRequestMetadata(MethodDescriptor<?, ?> methodDescriptor, Attributes attributes, Executor executor, CallCredentials.MetadataApplier metadataApplier) {
                metadataApplier.apply(metadata);
            }
        };
        return (T)stub.withCallCredentials(callCredentials);
    }

    private ListenableFuture<AuthenticateResponse> authenticate(ManagedChannel channel, ByteString name, ByteString password) {
        ListenableFuture<AuthenticateResponse> authResp = AuthGrpc.newFutureStub((Channel)channel).authenticate(AuthenticateRequest.newBuilder().setNameBytes(name).setPasswordBytes(password).build());
        return authResp;
    }

    private String getToken(EtcdClientBuilder builder) throws ConnectException, AuthFailedException {
        if (builder.getName() != null || builder.getPassword() != null) {
            Preconditions.checkNotNull((Object)builder.getName(), (Object)"username can not be null.");
            Preconditions.checkNotNull((Object)builder.getPassword(), (Object)"password can not be null.");
            Preconditions.checkArgument((builder.getName().toStringUtf8().trim().length() != 0 ? 1 : 0) != 0, (Object)"username can not be null.");
            Preconditions.checkArgument((builder.getPassword().toStringUtf8().trim().length() != 0 ? 1 : 0) != 0, (Object)"password can not be null.");
            try {
                return ((AuthenticateResponse)this.authenticate(this.channel, builder.getName(), builder.getPassword()).get()).getToken();
            }
            catch (InterruptedException ite) {
                throw new ConnectException("connect to etcd failed", ite);
            }
            catch (ExecutionException exee) {
                throw new AuthFailedException("auth failed as wrong username or password", exee);
            }
        }
        return null;
    }

    public void close() {
        this.channel.shutdownNow();
    }

    private AbstractEtcdNameResolverFactory getSimpleNameResolveFactory(String[] endpoints) {
        URI[] uris = new URI[endpoints.length];
        for (int i = 0; i < endpoints.length; ++i) {
            try {
                String endpoint = endpoints[i];
                if (!endpoint.startsWith("http://")) {
                    endpoint = "http://" + endpoint;
                }
                uris[i] = new URI(endpoint);
                continue;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return new SimpleEtcdNameResolverFactory(uris);
    }
}

