/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd;

import com.coreos.jetcd.EtcdCluster;
import com.coreos.jetcd.api.ClusterGrpc;
import com.coreos.jetcd.api.MemberAddRequest;
import com.coreos.jetcd.api.MemberAddResponse;
import com.coreos.jetcd.api.MemberListRequest;
import com.coreos.jetcd.api.MemberListResponse;
import com.coreos.jetcd.api.MemberRemoveRequest;
import com.coreos.jetcd.api.MemberRemoveResponse;
import com.coreos.jetcd.api.MemberUpdateRequest;
import com.coreos.jetcd.api.MemberUpdateResponse;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public class EtcdClusterImpl
implements EtcdCluster {
    private ClusterGrpc.ClusterFutureStub clusterStub;

    public EtcdClusterImpl(ClusterGrpc.ClusterFutureStub stub) {
        this.clusterStub = stub;
    }

    @Override
    public ListenableFuture<MemberListResponse> listMember() {
        return this.clusterStub.memberList(MemberListRequest.getDefaultInstance());
    }

    @Override
    public ListenableFuture<MemberAddResponse> addMember(List<String> endpoints) {
        MemberAddRequest memberAddRequest = MemberAddRequest.newBuilder().addAllPeerURLs(endpoints).build();
        return this.clusterStub.memberAdd(memberAddRequest);
    }

    @Override
    public ListenableFuture<MemberRemoveResponse> removeMember(long memberID) {
        MemberRemoveRequest memberRemoveRequest = MemberRemoveRequest.newBuilder().setID(memberID).build();
        return this.clusterStub.memberRemove(memberRemoveRequest);
    }

    @Override
    public ListenableFuture<MemberUpdateResponse> updateMember(long memberID, List<String> endpoints) {
        MemberUpdateRequest memberUpdateRequest = MemberUpdateRequest.newBuilder().addAllPeerURLs(endpoints).setID(memberID).build();
        return this.clusterStub.memberUpdate(memberUpdateRequest);
    }
}

