/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd;

import com.coreos.jetcd.EtcdKV;
import com.coreos.jetcd.api.CompactionRequest;
import com.coreos.jetcd.api.CompactionResponse;
import com.coreos.jetcd.api.DeleteRangeRequest;
import com.coreos.jetcd.api.DeleteRangeResponse;
import com.coreos.jetcd.api.KVGrpc;
import com.coreos.jetcd.api.PutRequest;
import com.coreos.jetcd.api.PutResponse;
import com.coreos.jetcd.api.RangeRequest;
import com.coreos.jetcd.api.RangeResponse;
import com.coreos.jetcd.api.TxnResponse;
import com.coreos.jetcd.op.Txn;
import com.coreos.jetcd.options.CompactOption;
import com.coreos.jetcd.options.DeleteOption;
import com.coreos.jetcd.options.GetOption;
import com.coreos.jetcd.options.PutOption;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;

class EtcdKVImpl
implements EtcdKV {
    private final KVGrpc.KVFutureStub kvStub;

    EtcdKVImpl(KVGrpc.KVFutureStub kvStub) {
        this.kvStub = kvStub;
    }

    @Override
    public ListenableFuture<PutResponse> put(ByteString key, ByteString value) {
        return this.put(key, value, PutOption.DEFAULT);
    }

    @Override
    public ListenableFuture<PutResponse> put(ByteString key, ByteString value, PutOption option) {
        Preconditions.checkNotNull((Object)key, (Object)"key should not be null");
        Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
        Preconditions.checkNotNull((Object)option, (Object)"option should not be null");
        PutRequest request = PutRequest.newBuilder().setKey(key).setValue(value).setLease(option.getLeaseId()).setPrevKv(option.getPrevKV()).build();
        return this.kvStub.put(request);
    }

    @Override
    public ListenableFuture<RangeResponse> get(ByteString key) {
        return this.get(key, GetOption.DEFAULT);
    }

    @Override
    public ListenableFuture<RangeResponse> get(ByteString key, GetOption option) {
        Preconditions.checkNotNull((Object)key, (Object)"key should not be null");
        Preconditions.checkNotNull((Object)option, (Object)"option should not be null");
        RangeRequest.Builder builder = RangeRequest.newBuilder().setKey(key).setCountOnly(option.isCountOnly()).setLimit(option.getLimit()).setRevision(option.getRevision()).setKeysOnly(option.isKeysOnly()).setSerializable(option.isSerializable()).setSortOrder(option.getSortOrder()).setSortTarget(option.getSortField());
        if (option.getEndKey().isPresent()) {
            builder.setRangeEnd(option.getEndKey().get());
        }
        return this.kvStub.range(builder.build());
    }

    @Override
    public ListenableFuture<DeleteRangeResponse> delete(ByteString key) {
        return this.delete(key, DeleteOption.DEFAULT);
    }

    @Override
    public ListenableFuture<DeleteRangeResponse> delete(ByteString key, DeleteOption option) {
        Preconditions.checkNotNull((Object)key, (Object)"key should not be null");
        Preconditions.checkNotNull((Object)option, (Object)"option should not be null");
        DeleteRangeRequest.Builder builder = DeleteRangeRequest.newBuilder().setKey(key).setPrevKv(option.isPrevKV());
        if (option.getEndKey().isPresent()) {
            builder.setRangeEnd((ByteString)option.getEndKey().get());
        }
        return this.kvStub.deleteRange(builder.build());
    }

    @Override
    public ListenableFuture<CompactionResponse> compact() {
        return this.compact(CompactOption.DEFAULT);
    }

    @Override
    public ListenableFuture<CompactionResponse> compact(CompactOption option) {
        Preconditions.checkNotNull((Object)option, (Object)"option should not be null");
        CompactionRequest request = CompactionRequest.newBuilder().setRevision(option.getRevision()).setPhysical(option.isPhysical()).build();
        return this.kvStub.compact(request);
    }

    @Override
    public ListenableFuture<TxnResponse> commit(Txn txn) {
        Preconditions.checkNotNull((Object)txn, (Object)"txn should not be null");
        return this.kvStub.txn(txn.toTxnRequest());
    }
}

